/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EC2InstanceInfo {
    private final ReservationDescription.Instance instance;

    public EC2InstanceInfo(ReservationDescription.Instance instance) {
        this.instance = instance;
    }

    public String getAvailabilityZone() {
        return this.instance.getAvailabilityZone();
    }

    public String getDnsName() {
        return this.instance.getDnsName();
    }

    @Nullable
    public EC2InstanceType getInstanceType() {
        return EC2InstanceType.convertFromTypica(this.instance.getInstanceType());
    }

    public Date getLaunchTime() {
        return this.instance.getLaunchTime().getTime();
    }

    public String getId() {
        return this.instance.getInstanceId();
    }

    @NotNull
    public AwsSupportConstants.InstanceStateName getState() {
        try {
            return AwsSupportConstants.InstanceStateName.fromValue(this.instance.getState());
        }
        catch (IllegalArgumentException e) {
            return AwsSupportConstants.InstanceStateName.UNIDENTIFIED;
        }
    }
}

