/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EBSVolume;
import com.atlassian.aws.ec2.EBSVolumeImpl;
import com.atlassian.aws.ec2.EBSVolumeManager;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.UpdateScheduler;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.xerox.amazonws.ec2.AttachmentInfo;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.VolumeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EBSVolumeManagerImpl
implements EBSVolumeManager,
Runnable {
    private static final Logger log = Logger.getLogger(EBSVolumeManagerImpl.class);
    private static final Function<String, List<VolumeInfo>> EMPTY_LIST_FUNCTION = new Function<String, List<VolumeInfo>>(){

        public List<VolumeInfo> apply(String s) {
            return Lists.newArrayList();
        }
    };
    private final Jec2 jec2;
    private final AtomicReference<Map<String, List<VolumeInfo>>> volumeMapReference = new AtomicReference<ConcurrentMap>(new MapMaker().makeComputingMap(EMPTY_LIST_FUNCTION));

    public EBSVolumeManagerImpl(Jec2 jec2, UpdateScheduler updateScheduler) {
        this.jec2 = jec2;
        if (updateScheduler != null) {
            updateScheduler.addUpdateTask(this);
        }
    }

    @Override
    public List<EBSVolume> getAttachedVolumes(final RemoteEC2Instance ec2Instance) throws AWSException {
        return Lists.transform(this.volumeMapReference.get().get(ec2Instance.getInstanceId()), (Function)new Function<VolumeInfo, EBSVolume>(){

            public EBSVolume apply(VolumeInfo volumeInfo) {
                return new EBSVolumeImpl(volumeInfo, ec2Instance, EBSVolumeManagerImpl.this.jec2);
            }
        });
    }

    @Override
    public void run() {
        try {
            ConcurrentMap updatedMap = new MapMaker().makeComputingMap(EMPTY_LIST_FUNCTION);
            List volumeInfos = this.jec2.describeVolumes(Collections.emptyList());
            for (VolumeInfo volumeInfo : volumeInfos) {
                List attachmentInfos = volumeInfo.getAttachmentInfo();
                for (AttachmentInfo attachmentInfo : attachmentInfos) {
                    String instanceId = attachmentInfo.getInstanceId();
                    if (!StringUtils.isNotEmpty((String)instanceId)) continue;
                    List volumes = (List)updatedMap.get(instanceId);
                    volumes.add(volumeInfo);
                }
            }
            this.volumeMapReference.set(updatedMap);
        }
        catch (EC2Exception e) {
            log.error((Object)"Could not retrieve volume descriptions.", (Throwable)e);
        }
    }
}

