/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EBSVolume;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.VolumeInfo;
import org.apache.log4j.Logger;

class EBSVolumeImpl
implements EBSVolume {
    private static final Logger log = Logger.getLogger(EBSVolumeImpl.class);
    private final VolumeInfo volumeInfo;
    private final RemoteEC2Instance remoteEC2Instance;
    private final Jec2 jec2;

    EBSVolumeImpl(VolumeInfo volumeInfo, RemoteEC2Instance remoteEC2Instance, Jec2 jec2) {
        this.volumeInfo = volumeInfo;
        this.remoteEC2Instance = remoteEC2Instance;
        this.jec2 = jec2;
    }

    @Override
    public String getID() {
        return this.volumeInfo.getVolumeId();
    }

    @Override
    public void delete() throws AWSException {
        String volumeId = this.volumeInfo.getVolumeId();
        String instanceId = this.remoteEC2Instance.getInstanceId();
        try {
            this.jec2.detachVolume(volumeId, instanceId, null, true);
        }
        catch (EC2Exception exception) {
            log.warn((Object)("Attempt to detach EBS volume " + volumeId + " from EC2 instance " + instanceId + " failed.  Proceeding with deletion."), (Throwable)exception);
        }
        try {
            this.jec2.deleteVolume(volumeId);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to delete EBS volume " + volumeId, exception);
        }
    }
}

