/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.auth.AWSCredentials;
import com.xerox.amazonws.ec2.Jec2;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RetryingJec2
extends Jec2 {
    private static final Logger log = Logger.getLogger(RetryingJec2.class);
    private static final Pattern ACTION_REGEX = Pattern.compile("\\b(Action=)([^&]*)");

    public RetryingJec2(AWSCredentials awsCredentials, boolean useSecureConnection) {
        super(awsCredentials.getAWSAccessKeyId(), awsCredentials.getAWSSecretKey(), useSecureConnection);
    }

    public RetryingJec2(AWSCredentials awsCredentials, boolean useSecureConnection, String cloudControllerHost, int port) {
        super(awsCredentials.getAWSAccessKeyId(), awsCredentials.getAWSSecretKey(), useSecureConnection, cloudControllerHost, port);
    }

    public void configureRetries() {
        HttpClient httpClient = this.getHttpClient();
        final HttpMethodRetryHandler typicaRetryHandler = (HttpMethodRetryHandler)httpClient.getParams().getParameter("http.method.retry-handler");
        DefaultHttpMethodRetryHandler timeoutAwareRetryHandler = new DefaultHttpMethodRetryHandler(this.getMaxRetries(), true){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                log.warn((Object)("Error while contacting EC2 for [" + RetryingJec2.extractActionFromQuery(method.getQueryString()) + "], (attempt " + executionCount + ")"));
                log.trace((Object)"", (Throwable)exception);
                boolean rc = typicaRetryHandler != null ? typicaRetryHandler.retryMethod(method, exception, executionCount) : super.retryMethod(method, exception, executionCount);
                if (exception instanceof SocketTimeoutException) {
                    return executionCount < this.getRetryCount();
                }
                return rc;
            }
        };
        httpClient.getParams().setParameter("http.method.retry-handler", (Object)timeoutAwareRetryHandler);
    }

    @Nullable
    static String extractActionFromQuery(@Nullable String query) {
        if (StringUtils.isBlank((String)query)) {
            return null;
        }
        Matcher matcher = ACTION_REGEX.matcher(query);
        return matcher.find() ? matcher.group(2) : null;
    }
}

