/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2AsyncClient;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.RetryingJec2;
import com.xerox.amazonws.ec2.Jec2;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class Ec2ClientFactoryImpl
implements Ec2ClientFactory {
    private final String cloudControllerHost;
    private final int port;
    private final boolean useSecureConnection;
    private static final int DEFAULT_TRANSMISSION_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_MAX_RETRIES = 5;
    private int transmissionTimeoutSeconds = 30;
    private int maxRetries = 5;

    public Ec2ClientFactoryImpl() {
        this(null, 0);
    }

    public Ec2ClientFactoryImpl(String cloudControllerHost, int port) {
        this(cloudControllerHost, port, true);
    }

    public Ec2ClientFactoryImpl(String cloudControllerHost, int port, boolean useSecureConnection) {
        if (cloudControllerHost != null && port <= 0) {
            throw new IllegalArgumentException("You must specify a valid port if an alternative cloudControllerHost is also specified");
        }
        this.cloudControllerHost = cloudControllerHost;
        this.port = port;
        this.useSecureConnection = useSecureConnection;
    }

    @Override
    @NotNull
    public Jec2 newTypicaClient(@NotNull AWSCredentials awsCredentials) {
        RetryingJec2 jec2 = this.cloudControllerHost == null ? new RetryingJec2(awsCredentials, this.useSecureConnection) : new RetryingJec2(awsCredentials, this.useSecureConnection, this.cloudControllerHost, this.port);
        jec2.useSystemProxy();
        jec2.setSoTimeout((int)TimeUnit.SECONDS.toMillis(this.transmissionTimeoutSeconds));
        jec2.setConnectionTimeout((int)TimeUnit.SECONDS.toMillis(this.transmissionTimeoutSeconds));
        jec2.setMaxRetries(this.maxRetries);
        jec2.configureRetries();
        return jec2;
    }

    @Override
    @NotNull
    public AmazonEC2AsyncClient newAwsAsyncClient(@NotNull AWSCredentials awsCredentials, @NotNull ScheduledExecutorService scheduledExecutorService) {
        int transmissionTimeoutMs = (int)TimeUnit.SECONDS.toMillis(this.transmissionTimeoutSeconds);
        ClientConfiguration clientConfiguration = new ClientConfiguration().withSocketTimeout(transmissionTimeoutMs).withConnectionTimeout(transmissionTimeoutMs).withMaxErrorRetry(this.maxRetries);
        this.applyProxyProperties(clientConfiguration, "https");
        if (clientConfiguration.getProxyHost() == null || clientConfiguration.getProxyPort() == -1) {
            this.applyProxyProperties(clientConfiguration, "http");
        }
        return new AmazonEC2AsyncClient(awsCredentials, clientConfiguration, (ExecutorService)scheduledExecutorService);
    }

    private void applyProxyProperties(ClientConfiguration clientConfiguration, String protocol) {
        String proxyHost = System.getProperty(protocol + ".proxyHost");
        int proxyPort = Integer.getInteger(protocol + ".proxyPort", -1);
        if (proxyHost != null && proxyPort > 0) {
            clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort);
        }
    }

    public void setTransmissionTimeout(int transmissionTimeoutSeconds) {
        this.transmissionTimeoutSeconds = transmissionTimeoutSeconds;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

