/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.atlassian.aws.utils.RecentLazyReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AwsOmeCache<T> {
    private static final int DEFAULT_MAXIMUM_DATA_AGE_SECONDS = 10;
    private final RecentLazyReference<Map<String, T>> recentData;
    private Logger log;

    public AwsOmeCache(final Logger log, long maximumDataAge, TimeUnit maximumDataAgeUnit) {
        this.log = log;
        this.recentData = new RecentLazyReference<Map<String, T>>(maximumDataAge, maximumDataAgeUnit){

            @Override
            protected Map<String, T> createInstance() throws Exception {
                log.debug((Object)"existing data is stale, requesting new data");
                List resources = AwsOmeCache.this.refreshAllData();
                HashMap resourceId2resourceMap = Maps.newHashMap();
                for (Object resource : resources) {
                    resourceId2resourceMap.put(AwsOmeCache.this.toResourceId(resource), resource);
                }
                return Collections.unmodifiableMap(resourceId2resourceMap);
            }
        };
    }

    public AwsOmeCache(Logger log) {
        this(log, 10L, TimeUnit.SECONDS);
    }

    private Collection<T> filterResources(Map<String, T> resourceId2resource, String[] resourceIds, boolean isDataPotentiallyStale) {
        ArrayList result = Lists.newArrayList();
        for (String resourceId : resourceIds) {
            T resource = resourceId2resource.get(resourceId);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            if (isDataPotentiallyStale) {
                this.log.debug((Object)("cache miss on [" + resourceId + "]"));
                this.recentData.reset();
                return this.filterResources(this.recentData.get(), resourceIds, false);
            }
            this.log.warn((Object)("query for a non-existing resource [" + resourceId + "]"));
            this.onResourceLookupFailure(resourceId);
        }
        return result;
    }

    public Collection<T> describe(String ... resourceIds) {
        boolean noFiltering = resourceIds.length == 0;
        this.log.debug((Object)("describing resources: " + (noFiltering ? "ALL" : Arrays.toString(resourceIds))));
        Map<String, T> resourceId2ResourceMap = this.recentData.get();
        Collection<T> resources = noFiltering ? resourceId2ResourceMap.values() : this.filterResources(resourceId2ResourceMap, resourceIds, true);
        return resources;
    }

    public void setMaximumStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.recentData.setRecentPredicate(maximumStatusAgeSeconds, TimeUnit.SECONDS);
    }

    protected abstract List<T> refreshAllData();

    protected abstract String toResourceId(T var1);

    protected abstract void onResourceLookupFailure(String var1);
}

