/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSAccountImpl;
import com.atlassian.aws.AWSManager;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.Ec2ClientFactoryImpl;
import com.atlassian.aws.ec2.UpdateScheduler;
import com.atlassian.aws.ec2.UpdateSchedulerImpl;
import java.util.concurrent.ScheduledExecutorService;

public class AWSManagerImpl
implements AWSManager {
    private final Ec2ClientFactory ec2ClientFactory;
    private final ScheduledExecutorService scheduledExecutorService;
    private final UpdateScheduler updateScheduler;

    public AWSManagerImpl(ScheduledExecutorService scheduledExecutorService) {
        this(new Ec2ClientFactoryImpl(), scheduledExecutorService);
    }

    public AWSManagerImpl(Ec2ClientFactory ec2ClientFactory, ScheduledExecutorService scheduledExecutorService) {
        this.ec2ClientFactory = ec2ClientFactory;
        this.scheduledExecutorService = scheduledExecutorService;
        this.updateScheduler = new UpdateSchedulerImpl(scheduledExecutorService);
    }

    @Override
    public AWSAccount getAWSAccount(String awsAccessId, String awsSecretKey) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(awsAccessId, awsSecretKey);
        return new AWSAccountImpl(this.ec2ClientFactory, this.scheduledExecutorService, (AWSCredentials)awsCredentials, this.updateScheduler);
    }
}

