/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2AsyncClient;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Volume;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.ec2.EBSVolumeManager;
import com.atlassian.aws.ec2.EBSVolumeManagerImpl;
import com.atlassian.aws.ec2.EC2AvailabilityZone;
import com.atlassian.aws.ec2.EC2AvailabilityZoneImpl;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2KeyPairDescription;
import com.atlassian.aws.ec2.EC2KeyPairDescriptionImpl;
import com.atlassian.aws.ec2.EC2PrivateKey;
import com.atlassian.aws.ec2.EC2PrivateKeyImpl;
import com.atlassian.aws.ec2.EC2SecurityGroup;
import com.atlassian.aws.ec2.EC2SecurityGroupImpl;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.RemoteEC2InstanceImpl;
import com.atlassian.aws.ec2.SpotPriceMatrix;
import com.atlassian.aws.ec2.UpdateScheduler;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.caches.InstanceCache;
import com.atlassian.aws.ec2.caches.SpotRequestCache;
import com.atlassian.aws.ec2.caches.VolumeCache;
import com.atlassian.aws.ec2.configuration.EC2Image;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.ConsoleOutput;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AWSAccountImpl
implements AWSAccount {
    private static final Logger log = Logger.getLogger(AWSAccountImpl.class);
    private static final int DEFAULT_SUPERVISION_INTERVAL_SECONDS = 20;
    private int supervisionIntervalSeconds = 20;
    private static final int MAX_SUCCESSIVE_SUPERVISION_FAILURES = 10;
    private static final List<String> INVALID_CREDENTIALS_MESSAGES = Collections.unmodifiableList(Arrays.asList("Client error : The AWS Access Key Id you provided does not exist in our records.", "Client error : The request signature we calculated does not match the signature you provided. Check your AWS Secret Access Key and signing method. Consult the service documentation for details.", "Client error : You are not subscribed to this service."));
    private final ScheduledExecutorService scheduledExecutorService;
    private final Jec2 jec2;
    private final AmazonEC2AsyncClient asyncEc2Client;
    private final EBSVolumeManager ebsVolumeManager;
    private final SpotRequestCache spotRequestCache;
    private final InstanceCache instanceCache;
    private final VolumeCache volumeCache;

    AWSAccountImpl(Ec2ClientFactory ec2ClientFactory, ScheduledExecutorService scheduledExecutorService, AWSCredentials awsCredentials, UpdateScheduler updateScheduler) {
        if (StringUtils.isBlank((String)awsCredentials.getAWSAccessKeyId()) || StringUtils.isBlank((String)awsCredentials.getAWSSecretKey())) {
            throw new IllegalArgumentException("awsAccessId and awsSecretKey must be specified.");
        }
        this.scheduledExecutorService = scheduledExecutorService;
        this.jec2 = ec2ClientFactory.newTypicaClient(awsCredentials);
        this.ebsVolumeManager = new EBSVolumeManagerImpl(this.jec2, updateScheduler);
        this.asyncEc2Client = ec2ClientFactory.newAwsAsyncClient(awsCredentials, scheduledExecutorService);
        this.spotRequestCache = new SpotRequestCache((AmazonEC2Client)this.asyncEc2Client);
        this.instanceCache = new InstanceCache((AmazonEC2Client)this.asyncEc2Client);
        this.volumeCache = new VolumeCache((AmazonEC2Client)this.asyncEc2Client);
    }

    @Override
    public boolean validate() throws AWSException {
        try {
            this.jec2.describeAvailabilityZones(null);
        }
        catch (EC2Exception exception) {
            for (String message : INVALID_CREDENTIALS_MESSAGES) {
                if (!exception.getMessage().startsWith(message)) continue;
                return false;
            }
            throw new AWSException("Failed to determine validity of AWS credentials.", exception);
        }
        return true;
    }

    @Override
    @Nullable
    public String getConsoleOutput(String instanceId) {
        try {
            ConsoleOutput output = this.jec2.getConsoleOutput(instanceId);
            return StringUtils.trimToNull((String)output.getOutput());
        }
        catch (EC2Exception e) {
            log.warn((Object)("Unable to get console output for " + instanceId + ". Null being returned."), (Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public Collection<Instance> getAllInstances() throws AWSException {
        try {
            Collection describeInstancesResult = this.instanceCache.describe(new String[0]);
            return Collections2.filter(describeInstancesResult, (Predicate)new Predicate<Instance>(){

                public boolean apply(@NotNull Instance instance) {
                    return !AwsSupportConstants.InstanceStateName.Terminated.is(instance.getState());
                }
            });
        }
        catch (AmazonClientException e) {
            throw new AWSException("Unable to retrieve the list of running elastic instances.", e);
        }
    }

    @Override
    @NotNull
    public Collection<SpotInstanceRequest> describePendingSpotInstanceRequests(String ... spotInstanceRequestIds) {
        Collection describe = this.spotRequestCache.describe(spotInstanceRequestIds);
        return Collections2.filter(describe, (Predicate)new Predicate<SpotInstanceRequest>(){

            public boolean apply(@NotNull SpotInstanceRequest spotInstanceRequest) {
                return AwsSupportConstants.SpotInstanceRequestState.OPEN.is(spotInstanceRequest.getState());
            }
        });
    }

    @Override
    @NotNull
    public RemoteEC2Instance newEC2Instance(EC2Image image, String keyName, List<String> securityGroupIds, Object userData, EC2InstanceType instanceType, String availabilityZone, int timeoutSeconds, EC2InstanceListener listener) {
        RemoteEC2InstanceImpl ec2Instance = new RemoteEC2InstanceImpl(image, keyName, securityGroupIds, userData, instanceType, availabilityZone, this.supervisionIntervalSeconds, 10, timeoutSeconds, listener, this, this.scheduledExecutorService, null, this.ebsVolumeManager);
        return ec2Instance;
    }

    @Override
    @NotNull
    public Map<String, EC2SecurityGroup> getEC2SecurityGroups() throws AWSException {
        List groupDescriptions;
        try {
            groupDescriptions = this.jec2.describeSecurityGroups(Collections.emptyList());
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to query EC2 for group descriptions.", exception);
        }
        HashMap<String, EC2SecurityGroup> ec2SecurityGroups = new HashMap<String, EC2SecurityGroup>(groupDescriptions.size());
        for (GroupDescription groupDescription : groupDescriptions) {
            ec2SecurityGroups.put(groupDescription.getName(), new EC2SecurityGroupImpl(this.jec2, groupDescription));
        }
        return ec2SecurityGroups;
    }

    @Override
    @NotNull
    public EC2SecurityGroup newEC2SecurityGroup(String securityGroupId, String description) throws AWSException {
        try {
            this.jec2.createSecurityGroup(securityGroupId, description);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to create EC2 security group.", exception);
        }
        return new EC2SecurityGroupImpl(this.jec2, new GroupDescription(securityGroupId, description, null));
    }

    @Override
    @NotNull
    public Map<String, EC2KeyPairDescription> getEC2KeyPairDescriptions() throws AWSException {
        List keyPairInfos;
        try {
            keyPairInfos = this.jec2.describeKeyPairs(Collections.emptyList());
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to query EC2 for key pair descriptions.", exception);
        }
        HashMap<String, EC2KeyPairDescription> ec2KeyPairDescriptions = new HashMap<String, EC2KeyPairDescription>(keyPairInfos.size());
        for (KeyPairInfo keyPairInfo : keyPairInfos) {
            ec2KeyPairDescriptions.put(keyPairInfo.getKeyName(), new EC2KeyPairDescriptionImpl(keyPairInfo));
        }
        return ec2KeyPairDescriptions;
    }

    @Override
    @NotNull
    public EC2PrivateKey newEC2KeyPair(String name) throws AWSException {
        KeyPairInfo keyPairInfo;
        try {
            keyPairInfo = this.jec2.createKeyPair(name);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to create EC2 key pair.", exception);
        }
        return new EC2PrivateKeyImpl(keyPairInfo);
    }

    @Override
    @NotNull
    public Map<String, EC2AvailabilityZone> getAvailabilityZones() throws AWSException {
        return this.getAvailabilityZones(null);
    }

    @Override
    @NotNull
    public Map<String, EC2AvailabilityZone> getAvailabilityZones(@Nullable List<String> zones) throws AWSException {
        List availabilityZones;
        try {
            availabilityZones = this.jec2.describeAvailabilityZones(zones);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to query EC2 for availability zones descriptions.", exception);
        }
        HashMap<String, EC2AvailabilityZone> ec2AvailabilityZones = new HashMap<String, EC2AvailabilityZone>(availabilityZones.size());
        for (AvailabilityZone availabilityZone : availabilityZones) {
            ec2AvailabilityZones.put(availabilityZone.getName(), new EC2AvailabilityZoneImpl(availabilityZone));
        }
        return ec2AvailabilityZones;
    }

    @Override
    public void shutdownInstance(String instanceId) throws AWSException {
        try {
            this.jec2.terminateInstances(Collections.singletonList(instanceId));
        }
        catch (EC2Exception e) {
            throw new AWSException("Error terminating elastic instance with id '" + instanceId + "'", e);
        }
    }

    @Override
    public void deleteVolume(String volumeId) throws AWSException {
        try {
            this.jec2.deleteVolume(volumeId);
        }
        catch (EC2Exception e) {
            throw new AWSException("Error deleting ebs volume with id '" + volumeId + "'", e);
        }
    }

    @Override
    @NotNull
    public SpotPriceMatrix getCurrentSpotPrices() {
        DescribeSpotPriceHistoryRequest request = new DescribeSpotPriceHistoryRequest().withStartTime(new Date());
        return new SpotPriceMatrix(this.asyncEc2Client.describeSpotPriceHistory(request).getSpotPriceHistory());
    }

    @Override
    @NotNull
    public AmazonEC2AsyncClient getAwsClient() {
        return this.asyncEc2Client;
    }

    @Override
    public Collection<Instance> describeInstances(String ... instanceIds) {
        return this.instanceCache.describe(instanceIds);
    }

    @Override
    public Collection<SpotInstanceRequest> describeSpotInstanceRequests(String ... spotInstanceRequestIds) {
        return this.spotRequestCache.describe(spotInstanceRequestIds);
    }

    @Override
    @NotNull
    public Collection<Volume> describeVolumes() throws AWSException {
        try {
            return this.volumeCache.describe(new String[0]);
        }
        catch (Exception e) {
            throw new AWSException("Failed to retrieve information about EBS volumes.", e);
        }
    }

    @Override
    public void setMaximumEbsVolumeStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.volumeCache.setMaximumStatusAgeSeconds(maximumStatusAgeSeconds);
    }

    @Override
    public void setMaximumInstanceStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.supervisionIntervalSeconds = maximumStatusAgeSeconds;
        this.instanceCache.setMaximumStatusAgeSeconds(maximumStatusAgeSeconds);
    }

    @Override
    public void setMaximumSpotRequestStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.spotRequestCache.setMaximumStatusAgeSeconds(maximumStatusAgeSeconds);
    }
}

