/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.services.ec2.AmazonEC2AsyncClient;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Volume;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2AvailabilityZone;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2KeyPairDescription;
import com.atlassian.aws.ec2.EC2PrivateKey;
import com.atlassian.aws.ec2.EC2SecurityGroup;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.SpotPriceMatrix;
import com.atlassian.aws.ec2.configuration.EC2Image;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AWSAccount {
    public boolean validate() throws AWSException;

    @NotNull
    public RemoteEC2Instance newEC2Instance(EC2Image var1, String var2, List<String> var3, Object var4, EC2InstanceType var5, String var6, int var7, EC2InstanceListener var8);

    @NotNull
    public Map<String, EC2SecurityGroup> getEC2SecurityGroups() throws AWSException;

    @NotNull
    public EC2SecurityGroup newEC2SecurityGroup(String var1, String var2) throws AWSException;

    @NotNull
    public Map<String, EC2KeyPairDescription> getEC2KeyPairDescriptions() throws AWSException;

    @NotNull
    public EC2PrivateKey newEC2KeyPair(String var1) throws AWSException;

    @NotNull
    public Map<String, EC2AvailabilityZone> getAvailabilityZones() throws AWSException;

    @NotNull
    public Map<String, EC2AvailabilityZone> getAvailabilityZones(List<String> var1) throws AWSException;

    @Nullable
    public String getConsoleOutput(String var1);

    @NotNull
    public Collection<Instance> getAllInstances() throws AWSException;

    @NotNull
    public Collection<SpotInstanceRequest> describePendingSpotInstanceRequests(String ... var1);

    public Collection<Instance> describeInstances(String ... var1);

    public Collection<SpotInstanceRequest> describeSpotInstanceRequests(String ... var1);

    @NotNull
    public Collection<Volume> describeVolumes() throws AWSException;

    public void shutdownInstance(String var1) throws AWSException;

    public void deleteVolume(String var1) throws AWSException;

    @NotNull
    public SpotPriceMatrix getCurrentSpotPrices();

    public AmazonEC2AsyncClient getAwsClient();

    public void setMaximumEbsVolumeStatusAgeSeconds(int var1);

    public void setMaximumInstanceStatusAgeSeconds(int var1);

    public void setMaximumSpotRequestStatusAgeSeconds(int var1);
}

