/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class AwsSuppliers {
    @NotNull
    public static <T> Supplier<T> memoizeWithFixedTtl(@NotNull Supplier<T> supplier, @NotNull Duration ttl) {
        long ttlNanos = ttl.toNanos();
        Preconditions.checkArgument((ttlNanos > 0L ? 1 : 0) != 0);
        return new LazilyExpiringMemoizingSupplier<T>(supplier, ignored -> ttlNanos);
    }

    @NotNull
    public static <T> Supplier<T> memoizeWithAdaptiveTtl(Supplier<T> supplier, Duration minTtl, Duration maxTtl) {
        long minTtlNanos = minTtl.toNanos();
        Preconditions.checkArgument((minTtlNanos > 0L ? 1 : 0) != 0);
        long maxTtlNanos = maxTtl.toNanos();
        Preconditions.checkArgument((maxTtlNanos > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((minTtlNanos <= maxTtlNanos ? 1 : 0) != 0);
        return new LazilyExpiringMemoizingSupplier<T>(supplier, elapsed -> {
            if (elapsed >= maxTtlNanos) {
                return maxTtlNanos;
            }
            if (elapsed <= minTtlNanos) {
                return minTtlNanos;
            }
            return elapsed;
        });
    }

    private static class LazilyExpiringMemoizingSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private final LongUnaryOperator ttlCalculator;
        private volatile transient T value;
        private volatile transient long expirationTime;

        LazilyExpiringMemoizingSupplier(Supplier<T> supplier, LongUnaryOperator ttlCalculator) {
            this.supplier = Objects.requireNonNull(supplier);
            this.ttlCalculator = ttlCalculator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            long expirationTimeWhenMethodWasCalled = this.expirationTime;
            if (expirationTimeWhenMethodWasCalled == 0L || System.nanoTime() - expirationTimeWhenMethodWasCalled >= 0L) {
                LazilyExpiringMemoizingSupplier lazilyExpiringMemoizingSupplier = this;
                synchronized (lazilyExpiringMemoizingSupplier) {
                    if (expirationTimeWhenMethodWasCalled != this.expirationTime) {
                        return this.value;
                    }
                    long calculationStarted = System.nanoTime();
                    T calculated = this.supplier.get();
                    this.value = calculated;
                    long now = System.nanoTime();
                    long newExpirationTime = now + this.ttlCalculator.applyAsLong(now - calculationStarted);
                    this.expirationTime = newExpirationTime == 0L ? 1L : newExpirationTime;
                    return calculated;
                }
            }
            return this.value;
        }
    }
}

