/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.model;

import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.atlassian.aws.ec2.model.ResourceId;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class SecurityGroupId
extends ResourceId<SecurityGroupId> {
    private static final Function<SecurityGroupId, GroupIdentifier> TO_GROUP_IDENTIFIER = securityGroupId -> new GroupIdentifier().withGroupId(securityGroupId.getId());

    public SecurityGroupId(@NotNull String id) {
        super(id);
        Preconditions.checkArgument((boolean)id.startsWith("sg-"));
    }

    public static SecurityGroupId from(@NotNull String id) {
        return new SecurityGroupId(id);
    }

    public static SecurityGroupId from(@NotNull SecurityGroup securityGroup) {
        return SecurityGroupId.from(securityGroup.getGroupId());
    }

    public static Collection<GroupIdentifier> asGroupIdentifiers(Iterable<SecurityGroupId> securityGroups) {
        return StreamSupport.stream(securityGroups.spliterator(), false).map(TO_GROUP_IDENTIFIER).collect(Collectors.toList());
    }
}

