/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.Volume;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.AwsOmeCache;
import com.atlassian.aws.ec2.caches.Ec2CacheMissException;
import java.time.Duration;
import java.util.List;
import org.apache.log4j.Logger;

public class VolumeCache
extends AwsOmeCache<Volume> {
    private static final Logger log = Logger.getLogger(VolumeCache.class);
    private final AmazonEC2Async ec2Client;

    public VolumeCache(AmazonEC2Async ec2Client, Duration maximumDataAge) {
        super(log, maximumDataAge);
        this.ec2Client = ec2Client;
    }

    public VolumeCache(AmazonEC2Async ec2Client) {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<Volume> refreshAllData() {
        DescribeVolumesResult describeVolumesResult = this.ec2Client.describeVolumes();
        return describeVolumesResult.getVolumes();
    }

    @Override
    protected String toResourceId(Volume volume) {
        return volume.getVolumeId();
    }

    @Override
    protected void onResourceLookupFailure(String resourceId) {
        throw new Ec2CacheMissException(resourceId, AmazonServiceErrorCode.INVALID_VOLUME_NOT_FOUND);
    }
}

