/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.Subnet;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.AwsOmeCache;
import com.atlassian.aws.ec2.caches.Ec2CacheMissException;
import java.time.Duration;
import java.util.List;
import org.apache.log4j.Logger;

public class SubnetCache
extends AwsOmeCache<Subnet> {
    private static final Logger log = Logger.getLogger(SubnetCache.class);
    private final AmazonEC2Async ec2Client;

    public SubnetCache(AmazonEC2Async ec2Client, Duration maximumDataAge) {
        super(log, maximumDataAge);
        this.ec2Client = ec2Client;
    }

    public SubnetCache(AmazonEC2Async ec2Client) {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<Subnet> refreshAllData() {
        DescribeSubnetsResult describeVpcsResult = this.ec2Client.describeSubnets();
        return describeVpcsResult.getSubnets();
    }

    @Override
    protected String toResourceId(Subnet subnet) {
        return subnet.getSubnetId();
    }

    @Override
    protected void onResourceLookupFailure(String resourceId) {
        throw new Ec2CacheMissException(resourceId, AmazonServiceErrorCode.INVALID_SUBNET_ID_NOT_FOUND);
    }
}

