/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk.launch;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.model.ResourceId;
import com.atlassian.aws.ec2.model.SecurityGroupId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherUtils {
    static boolean isVpcEnabled(InstanceLaunchConfiguration instanceConfiguration) {
        return !Iterables.isEmpty(instanceConfiguration.getSubnets());
    }

    static Collection<BlockDeviceMapping> getBlockDeviceMappings(@NotNull AWSAccount awsAccount, @NotNull String imageId, @NotNull EC2InstanceType instanceType, @Nullable String snapshotId, @Nullable Integer rootFsSize) {
        Image image = awsAccount.describeImage(imageId);
        Preconditions.checkNotNull((Object)image, (Object)("Unable to find " + imageId + ", make sure it exists and your account has permissions to access it"));
        ArrayList<BlockDeviceMapping> newBdms = new ArrayList<BlockDeviceMapping>();
        if (rootFsSize != null) {
            Optional<BlockDeviceMapping> presumedRootBdm = image.getBlockDeviceMappings().stream().filter(bdm -> bdm.getEbs() != null && StringUtils.isNotBlank((CharSequence)bdm.getEbs().getSnapshotId())).findFirst();
            presumedRootBdm.ifPresent(rootBdm -> {
                EbsBlockDevice ebs = rootBdm.getEbs().withVolumeSize(rootFsSize);
                if (Objects.equals(Boolean.FALSE, ebs.isEncrypted())) {
                    ebs.setEncrypted(null);
                }
                newBdms.add((BlockDeviceMapping)rootBdm);
            });
        }
        newBdms.addAll(LauncherUtils.getEphemeralBlockDeviceMappings(image, instanceType));
        if (snapshotId != null) {
            newBdms.addAll(LauncherUtils.getEbsBlockDeviceMappings(image, snapshotId));
        }
        return newBdms;
    }

    private static Collection<BlockDeviceMapping> getEphemeralBlockDeviceMappings(@NotNull Image image, @NotNull EC2InstanceType instanceType) {
        ArrayList<BlockDeviceMapping> bdms = new ArrayList<BlockDeviceMapping>();
        int volumesToSetUp = instanceType.getSsdCnt() < 2 ? 1 : 2;
        for (int i = 0; i < volumesToSetUp; ++i) {
            BlockDeviceMapping ephemeralBlockDeviceMapping = new BlockDeviceMapping().withDeviceName(LauncherUtils.getInstanceStoreDeviceName(image, instanceType, i)).withVirtualName("ephemeral" + i);
            bdms.add(ephemeralBlockDeviceMapping);
        }
        return bdms;
    }

    private static String getInstanceStoreDeviceName(Image image, EC2InstanceType instanceType, int index) {
        if (!EC2Utils.isWindows(image)) {
            return "/dev/sd" + LauncherUtils.getLetterWithIndex(index + 1);
        }
        if (instanceType != EC2InstanceType.Hs18xlarge) {
            return "xvd" + LauncherUtils.getLetterWithIndex(index + 1);
        }
        return "xvdc" + LauncherUtils.getLetterWithIndex(index);
    }

    private static char getLetterWithIndex(int i) {
        return (char)(97 + i);
    }

    private static Collection<BlockDeviceMapping> getEbsBlockDeviceMappings(@NotNull Image image, @NotNull String snapshotId) {
        EbsBlockDevice ebs = new EbsBlockDevice().withDeleteOnTermination(Boolean.valueOf(true)).withSnapshotId(snapshotId);
        BlockDeviceMapping blockDeviceMapping = new BlockDeviceMapping().withDeviceName(EC2Utils.getEbsDeviceName(image)).withEbs(ebs);
        return Collections.singletonList(blockDeviceMapping);
    }

    public static InstanceNetworkInterfaceSpecification newPublicIpForVpc(@NotNull SubnetId subnetId, @NotNull Iterable<SecurityGroupId> securityGroups) {
        return new InstanceNetworkInterfaceSpecification().withAssociatePublicIpAddress(Boolean.valueOf(true)).withSubnetId(subnetId.getId()).withGroups(ResourceId.getIds(securityGroups)).withDeleteOnTermination(Boolean.valueOf(true)).withDeviceIndex(Integer.valueOf(0));
    }
}

