/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk.launch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.InstancePaymentType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.InstanceStatus;
import com.atlassian.aws.ec2.SubnetChooser;
import com.atlassian.aws.ec2.awssdk.AwsSpotInstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.InstanceLauncher;
import com.atlassian.aws.ec2.awssdk.launch.LauncherUtils;
import com.atlassian.aws.ec2.model.SecurityGroupId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class AwsSpotInstanceLauncher
implements InstanceLauncher {
    private static final Logger log = Logger.getLogger(AwsSpotInstanceLauncher.class);
    private final AWSAccount awsAccount;
    private final SubnetChooser subnetChooser;
    private final InstanceLaunchConfiguration instanceConfiguration;
    private final InstanceStatus instanceStatus;
    private final InstanceLauncher fallbackLauncher;

    AwsSpotInstanceLauncher(AWSAccount awsAccount, SubnetChooser subnetChooser, InstanceLaunchConfiguration instanceConfiguration, InstanceStatus instanceStatus, InstanceLauncher fallbackLauncher) {
        this.awsAccount = awsAccount;
        this.subnetChooser = subnetChooser;
        this.instanceConfiguration = instanceConfiguration;
        this.instanceStatus = instanceStatus;
        this.fallbackLauncher = fallbackLauncher;
    }

    @Override
    public Collection<InstanceReservationDescription> call() throws IOException, AmazonClientException {
        List placedSpotInstanceRequest;
        block4: {
            int spotRequestTimeoutSeconds = this.instanceConfiguration.getSpotRequestTimeoutSeconds();
            Date spotRequestValidityEnd = DateUtils.addSeconds((Date)new Date(), (int)spotRequestTimeoutSeconds);
            this.instanceStatus.setDeadline(2 * spotRequestTimeoutSeconds);
            LaunchSpecification spotLaunchSpecification = this.createSpotLaunchSpecification(this.instanceConfiguration);
            RequestSpotInstancesRequest requestSpotInstance = new RequestSpotInstancesRequest().withSpotPrice(Double.toString(this.instanceConfiguration.getSpotInstanceBid())).withInstanceCount(Integer.valueOf(1)).withValidUntil(spotRequestValidityEnd).withType("one-time").withLaunchSpecification(spotLaunchSpecification);
            placedSpotInstanceRequest = Collections.emptyList();
            try {
                placedSpotInstanceRequest = this.awsAccount.getAmazonEc2().requestSpotInstances(requestSpotInstance).getSpotInstanceRequests();
            }
            catch (AmazonServiceException e) {
                if (AmazonServiceErrorCode.MAX_SPOT_INSTANCE_COUNT_EXCEEDED.is(e)) break block4;
                throw e;
            }
        }
        if (placedSpotInstanceRequest.isEmpty()) {
            log.warn((Object)"Unable to place a spot instance request, proceeding with regular instance order");
            return this.fallbackLauncher.call();
        }
        this.instanceStatus.setInstancePaymentType(InstancePaymentType.SPOT);
        if (placedSpotInstanceRequest.size() > 1) {
            log.warn((Object)("A request for a single instance resulted in " + placedSpotInstanceRequest.size() + " being placed. Ignoring spurious spot instance requests."));
        }
        this.instanceStatus.setSpotInstanceRequestId(((SpotInstanceRequest)Iterables.getOnlyElement((Iterable)placedSpotInstanceRequest)).getSpotInstanceRequestId());
        return AwsSpotInstanceReservationDescription.create(placedSpotInstanceRequest);
    }

    private LaunchSpecification createSpotLaunchSpecification(InstanceLaunchConfiguration instanceConfiguration) {
        EC2InstanceType instanceType = this.getInstanceType(instanceConfiguration);
        String imageId = instanceConfiguration.getImage().getId();
        Collection<BlockDeviceMapping> blockDeviceMappings = LauncherUtils.getBlockDeviceMappings(this.awsAccount, imageId, instanceType, instanceConfiguration.getEbsSnapshotId(), instanceConfiguration.getRootFsSizeOverride());
        LaunchSpecification launchSpecification = new LaunchSpecification().withImageId(imageId).withKeyName(instanceConfiguration.getKeyName()).withIamInstanceProfile(instanceConfiguration.getIamInstanceProfile()).withBlockDeviceMappings(blockDeviceMappings).withEbsOptimized(Boolean.valueOf(instanceConfiguration.isEbsOptimised())).withInstanceType(instanceType.getAwsInstanceType());
        if (LauncherUtils.isVpcEnabled(instanceConfiguration)) {
            SubnetId subnetId = this.subnetChooser.choose(instanceConfiguration.getSubnets(), instanceType);
            Preconditions.checkNotNull((Object)subnetId);
            Iterable<SecurityGroupId> securityGroupIds = instanceConfiguration.getSecurityGroups(subnetId);
            if (instanceConfiguration.shouldAssociatePublicIp()) {
                launchSpecification.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{LauncherUtils.newPublicIpForVpc(subnetId, securityGroupIds)});
            } else {
                launchSpecification.withSubnetId(subnetId.getId()).withAllSecurityGroups(SecurityGroupId.asGroupIdentifiers(securityGroupIds));
            }
        } else {
            launchSpecification.withPlacement(new SpotPlacement(instanceConfiguration.getRequestedAvailabilityZone())).withAllSecurityGroups(SecurityGroupId.asGroupIdentifiers(instanceConfiguration.getSecurityGroups(null)));
        }
        launchSpecification.setUserData(EC2Utils.getUserDataAsString(instanceConfiguration.getUserData()));
        return launchSpecification;
    }

    @NotNull
    private EC2InstanceType getInstanceType(InstanceLaunchConfiguration instanceConfiguration) {
        Iterable<EC2InstanceType> instanceTypes = instanceConfiguration.getInstanceTypes();
        EC2InstanceType instanceType = (EC2InstanceType)((Object)Iterables.get(instanceTypes, (int)0));
        if (Iterables.size(instanceTypes) > 1) {
            log.info((Object)("Launching a non-spot fleet instance and the image configuration has more than one instance type defined, using " + (Object)((Object)instanceType)));
        }
        return instanceType;
    }
}

