/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk.launch;

import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import com.amazonaws.services.ec2.model.RequestSpotFleetResult;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfigData;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.InstancePaymentType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.InstanceStatus;
import com.atlassian.aws.ec2.SubnetChooser;
import com.atlassian.aws.ec2.awssdk.AwsSpotFleetInstanceRequest;
import com.atlassian.aws.ec2.awssdk.InstanceLauncher;
import com.atlassian.aws.ec2.awssdk.launch.LauncherUtils;
import com.atlassian.aws.ec2.model.SecurityGroupId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AwsSpotFleetLauncher
implements InstanceLauncher {
    private final AWSAccount awsAccount;
    private final SubnetChooser subnetChooser;
    private final InstanceLaunchConfiguration instanceConfiguration;
    private final InstanceStatus instanceStatus;

    AwsSpotFleetLauncher(AWSAccount awsAccount, SubnetChooser subnetChooser, InstanceLaunchConfiguration instanceConfiguration, InstanceStatus instanceStatus, InstanceLauncher fallbackLauncher) {
        this.awsAccount = awsAccount;
        this.subnetChooser = subnetChooser;
        this.instanceConfiguration = instanceConfiguration;
        this.instanceStatus = instanceStatus;
    }

    @Override
    public Collection<InstanceReservationDescription> call() throws IOException {
        int spotRequestTimeoutSeconds = this.instanceConfiguration.getSpotRequestTimeoutSeconds();
        Date spotRequestValidityEnd = DateUtils.addSeconds((Date)new Date(), (int)spotRequestTimeoutSeconds);
        this.instanceStatus.setDeadline(2 * spotRequestTimeoutSeconds);
        AmazonEC2Async amazonEc2 = this.awsAccount.getAmazonEc2();
        Collection<SpotFleetLaunchSpecification> launchSpecifications = this.createLaunchSpecifications();
        SpotFleetRequestConfigData spotFleetRequestConfigData = new SpotFleetRequestConfigData().withSpotPrice(Double.toString(this.instanceConfiguration.getSpotInstanceBid())).withTargetCapacity(Integer.valueOf(1)).withIamFleetRole("arn:aws:iam::121852097033:role/PrzemekFleetRole2").withValidUntil(spotRequestValidityEnd).withLaunchSpecifications(launchSpecifications).withTerminateInstancesWithExpiration(Boolean.valueOf(false)).withClientToken(RandomStringUtils.randomAlphanumeric((int)64));
        RequestSpotFleetRequest requestSpotFleetRequest = new RequestSpotFleetRequest().withSpotFleetRequestConfig(spotFleetRequestConfigData);
        RequestSpotFleetResult requestSpotFleetResult = amazonEc2.requestSpotFleet(requestSpotFleetRequest);
        this.instanceStatus.setInstancePaymentType(InstancePaymentType.SPOT);
        this.instanceStatus.setSpotInstanceRequestId(requestSpotFleetResult.getSpotFleetRequestId());
        return AwsSpotFleetInstanceRequest.create(requestSpotFleetResult, launchSpecifications);
    }

    private Collection<SpotFleetLaunchSpecification> createLaunchSpecifications() {
        Iterable<EC2InstanceType> instanceTypes = this.instanceConfiguration.getInstanceTypes();
        String imageId = this.instanceConfiguration.getImage().getId();
        ArrayList<SpotFleetLaunchSpecification> specifications = new ArrayList<SpotFleetLaunchSpecification>();
        for (EC2InstanceType instanceType : instanceTypes) {
            Collection<BlockDeviceMapping> blockDeviceMappings = LauncherUtils.getBlockDeviceMappings(this.awsAccount, imageId, instanceType, this.instanceConfiguration.getEbsSnapshotId(), this.instanceConfiguration.getRootFsSizeOverride());
            SpotFleetLaunchSpecification launchSpecification = new SpotFleetLaunchSpecification().withImageId(imageId).withKeyName(this.instanceConfiguration.getKeyName()).withIamInstanceProfile(this.instanceConfiguration.getIamInstanceProfile()).withBlockDeviceMappings(blockDeviceMappings).withEbsOptimized(Boolean.valueOf(this.instanceConfiguration.isEbsOptimised())).withInstanceType(instanceType.getAwsInstanceType());
            if (LauncherUtils.isVpcEnabled(this.instanceConfiguration)) {
                SubnetId subnetId = this.subnetChooser.choose(this.instanceConfiguration.getSubnets(), instanceType);
                Preconditions.checkNotNull((Object)subnetId);
                Iterable<SecurityGroupId> securityGroupIds = this.instanceConfiguration.getSecurityGroups(subnetId);
                if (this.instanceConfiguration.shouldAssociatePublicIp()) {
                    launchSpecification.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{LauncherUtils.newPublicIpForVpc(subnetId, securityGroupIds)});
                } else {
                    launchSpecification.withSubnetId(subnetId.getId()).withSecurityGroups(SecurityGroupId.asGroupIdentifiers(securityGroupIds));
                }
            } else {
                launchSpecification.withPlacement(new SpotPlacement(this.instanceConfiguration.getRequestedAvailabilityZone())).withSecurityGroups(SecurityGroupId.asGroupIdentifiers(this.instanceConfiguration.getSecurityGroups(null)));
            }
            Object userData = this.instanceConfiguration.getUserData();
            launchSpecification.setUserData(EC2Utils.getUserDataAsString(userData));
            specifications.add(launchSpecification);
        }
        return specifications;
    }
}

