/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk.launch;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.InstancePaymentType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.InstanceStatus;
import com.atlassian.aws.ec2.SubnetChooser;
import com.atlassian.aws.ec2.awssdk.AwsInstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.awssdk.InstanceLauncher;
import com.atlassian.aws.ec2.awssdk.launch.LauncherUtils;
import com.atlassian.aws.ec2.model.ResourceId;
import com.atlassian.aws.ec2.model.SecurityGroupId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.atlassian.aws.utils.Eithers;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AwsInstanceLauncher
implements InstanceLauncher {
    private static final Logger log = Logger.getLogger(AwsInstanceLauncher.class);
    private final AWSAccount awsAccount;
    private final SubnetChooser subnetChooser;
    private final InstanceLaunchConfiguration instanceConfiguration;
    private final InstanceStatus instanceStatus;

    AwsInstanceLauncher(AWSAccount awsAccount, SubnetChooser subnetChooser, InstanceLaunchConfiguration instanceConfiguration, InstanceStatus instanceStatus) {
        this.awsAccount = awsAccount;
        this.subnetChooser = subnetChooser;
        this.instanceConfiguration = instanceConfiguration;
        this.instanceStatus = instanceStatus;
    }

    @Override
    public Collection<InstanceReservationDescription> call() throws IOException {
        Pair<AmazonServiceException, RunInstancesResult> runInstancesResult;
        SubnetId subnetId;
        this.instanceStatus.setInstancePaymentType(InstancePaymentType.REGULAR);
        this.instanceStatus.setDeadline(this.instanceConfiguration.getStartupTimeoutInSeconds());
        EC2InstanceType instanceType = this.getInstanceType(this.instanceConfiguration);
        SubnetId firstSubnetId = subnetId = this.subnetChooser.choose(this.instanceConfiguration.getSubnets(), instanceType);
        do {
            if (!Eithers.isRight(runInstancesResult = this.runInstance(subnetId, instanceType))) continue;
            return AwsInstanceReservationDescription.create(((RunInstancesResult)runInstancesResult.getRight()).getReservation());
        } while ((subnetId = this.subnetChooser.choose(this.instanceConfiguration.getSubnets(), instanceType)) != null && !subnetId.equals(firstSubnetId));
        throw (AmazonServiceException)runInstancesResult.getLeft();
    }

    @NotNull
    private EC2InstanceType getInstanceType(InstanceLaunchConfiguration instanceConfiguration) {
        Iterable<EC2InstanceType> instanceTypes = instanceConfiguration.getInstanceTypes();
        EC2InstanceType instanceType = (EC2InstanceType)((Object)Iterables.get(instanceTypes, (int)0));
        if (Iterables.size(instanceTypes) > 1) {
            log.info((Object)("Launching a non-spot fleet instance and the image configuration has more than one instance type defined, using " + (Object)((Object)instanceType)));
        }
        return instanceType;
    }

    private Pair<AmazonServiceException, RunInstancesResult> runInstance(@Nullable SubnetId subnet, EC2InstanceType instanceType) {
        RunInstancesResult runInstancesResult;
        RunInstancesRequest runInstancesRequest = this.getRunInstancesRequest(subnet, instanceType);
        log.info((Object)("Ordering EC2 instance of image " + this.instanceConfiguration.getImage().getId() + (subnet != null ? " in subnet " + subnet : "")));
        try {
            runInstancesResult = this.awsAccount.getAmazonEc2().runInstances(runInstancesRequest);
        }
        catch (AmazonServiceException e) {
            if (!AmazonServiceErrorCode.INSUFFICIENT_INSTANCE_CAPACITY.is(e) || subnet == null) {
                throw e;
            }
            this.subnetChooser.blacklist(subnet, instanceType);
            return Eithers.left(e);
        }
        return Eithers.right(runInstancesResult);
    }

    private RunInstancesRequest getRunInstancesRequest(@Nullable SubnetId subnetId, EC2InstanceType instanceType) {
        String imageId = this.instanceConfiguration.getImage().getId();
        Collection<BlockDeviceMapping> blockDeviceMappings = LauncherUtils.getBlockDeviceMappings(this.awsAccount, imageId, instanceType, this.instanceConfiguration.getEbsSnapshotId(), this.instanceConfiguration.getRootFsSizeOverride());
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest().withImageId(imageId).withKeyName(this.instanceConfiguration.getKeyName()).withInstanceType(instanceType.getAwsInstanceType()).withInstanceInitiatedShutdownBehavior(AwsSupportConstants.InstanceInitiatedShutdownBehaviour.TERMINATE.toString()).withIamInstanceProfile(this.instanceConfiguration.getIamInstanceProfile()).withEbsOptimized(Boolean.valueOf(this.instanceConfiguration.isEbsOptimised())).withBlockDeviceMappings(blockDeviceMappings).withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1)).withClientToken(RandomStringUtils.randomAlphanumeric((int)64));
        Iterable<SecurityGroupId> securityGroupIds = this.instanceConfiguration.getSecurityGroups(subnetId);
        if (LauncherUtils.isVpcEnabled(this.instanceConfiguration)) {
            assert (subnetId != null);
            if (this.instanceConfiguration.shouldAssociatePublicIp()) {
                runInstancesRequest.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{LauncherUtils.newPublicIpForVpc(subnetId, securityGroupIds)});
            } else {
                runInstancesRequest.withSubnetId(subnetId.getId()).withSecurityGroupIds(ResourceId.getIds(securityGroupIds));
            }
        } else {
            runInstancesRequest.withPlacement(new Placement().withAvailabilityZone(this.instanceConfiguration.getRequestedAvailabilityZone())).withSecurityGroupIds(ResourceId.getIds(securityGroupIds));
        }
        runInstancesRequest.setUserData(EC2Utils.getUserDataAsString(this.instanceConfiguration.getUserData()));
        return runInstancesRequest;
    }
}

