/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.ActiveInstance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.SubnetId;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsSpotFleetActiveInstance
implements InstanceReservationDescription {
    private static final Logger log = Logger.getLogger(AwsSpotFleetActiveInstance.class);
    private final ActiveInstance activeInstance;

    public AwsSpotFleetActiveInstance(ActiveInstance activeInstance) {
        this.activeInstance = activeInstance;
    }

    @Override
    public String getInstanceId() {
        return this.activeInstance.getInstanceId();
    }

    @Override
    public String getAvailabilityZone() {
        return "n/a";
    }

    @Override
    @Nullable
    public SubnetId getSubnet() {
        return null;
    }

    @Override
    @NotNull
    public String getAddress() {
        return "n/a";
    }

    @Override
    @Nullable
    public InstanceType getInstanceType() {
        return InstanceType.fromValue((String)this.activeInstance.getInstanceType());
    }

    @Override
    @NotNull
    public String getHostname() {
        return "n/a";
    }

    @Override
    public AwsSupportConstants.InstanceStateName getState() {
        return AwsSupportConstants.InstanceStateName.SpotActive;
    }

    @Override
    public String getStateDescription() {
        return this.getState().toString();
    }
}

