/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.configuration.EC2Image;
import com.atlassian.aws.ec2.configuration.EC2ImageImpl;
import com.atlassian.aws.ec2.model.SecurityGroupId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceLaunchConfiguration {
    private final EC2Image image;
    private final Iterable<String> requestedAvailabilityZones;
    private final int startupTimeoutInSeconds;
    private final double spotInstanceBid;
    private final Iterable<EC2InstanceType> instanceTypes;
    private final Iterable<SubnetId> subnets;
    private final int spotRequestTimeoutSeconds;
    private final String keyName;
    private final ImmutableMultimap<SubnetId, SecurityGroupId> availableSecurityGroups;
    private final Object userData;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String ebsSnapshotId;
    private final boolean shouldAssociatePublicIp;
    private final boolean ebsOptimised;
    private Integer rootFsSizeOverride;

    public InstanceLaunchConfiguration(String imageId, String keyName, ImmutableMultimap<SubnetId, SecurityGroupId> availableSecurityGroups, Iterable<String> requestedAvailabilityZones, int startupTimeoutInSeconds, Collection<String> subnetIds, int spotRequestTimeoutSeconds, Object userData, double spotInstanceBid, Iterable<EC2InstanceType> instanceTypes, @Nullable IamInstanceProfileSpecification iamInstanceProfile, @Nullable String ebsSnapshotId, boolean ebsOptmised, boolean shouldAssociatePublicIp, @Nullable Integer rootFsSizeOverride) {
        this.iamInstanceProfile = iamInstanceProfile;
        this.ebsSnapshotId = ebsSnapshotId;
        this.image = new EC2ImageImpl(imageId);
        this.requestedAvailabilityZones = requestedAvailabilityZones;
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
        this.subnets = subnetIds == null ? Collections.emptyList() : SubnetId.from(subnetIds);
        this.spotRequestTimeoutSeconds = spotRequestTimeoutSeconds;
        this.keyName = keyName;
        this.availableSecurityGroups = availableSecurityGroups;
        this.userData = userData;
        this.spotInstanceBid = spotInstanceBid;
        this.instanceTypes = instanceTypes == null ? Collections.singleton(EC2InstanceType.DEFAULT) : instanceTypes;
        this.ebsOptimised = ebsOptmised;
        this.shouldAssociatePublicIp = shouldAssociatePublicIp;
        this.rootFsSizeOverride = rootFsSizeOverride;
    }

    public double getSpotInstanceBid() {
        return this.spotInstanceBid;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public EC2Image getImage() {
        return this.image;
    }

    public String getKeyName() {
        return this.keyName;
    }

    @NotNull
    public Iterable<SecurityGroupId> getSecurityGroups(@Nullable SubnetId subnetId) {
        return this.availableSecurityGroups.get(MoreObjects.firstNonNull((Object)subnetId, (Object)SubnetId.NO_SUBNET));
    }

    public Iterable<EC2InstanceType> getInstanceTypes() {
        return this.instanceTypes;
    }

    public String getRequestedAvailabilityZone() {
        return (String)Iterables.getFirst(this.requestedAvailabilityZones, null);
    }

    @NotNull
    public Iterable<SubnetId> getSubnets() {
        return this.subnets;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int getSpotRequestTimeoutSeconds() {
        return this.spotRequestTimeoutSeconds;
    }

    public boolean isSpotRequestTimeoutExpired(long timeElapsed) {
        return timeElapsed > (long)this.spotRequestTimeoutSeconds;
    }

    @Nullable
    public IamInstanceProfileSpecification getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    @Nullable
    public String getEbsSnapshotId() {
        return this.ebsSnapshotId;
    }

    public boolean isEbsOptimised() {
        return this.ebsOptimised;
    }

    public boolean shouldAssociatePublicIp() {
        return this.shouldAssociatePublicIp;
    }

    @Nullable
    public Integer getRootFsSizeOverride() {
        return this.rootFsSizeOverride;
    }
}

