/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.Protocol;
import org.jetbrains.annotations.NotNull;

public class AmazonEc2Utils {
    public static void ensureInboundTrafficIsAllowed(AmazonEC2 amazonEc2, @NotNull SecurityGroup group, @NotNull Protocol protocol, @NotNull String cidrIpRange, int port) {
        boolean matchFound;
        boolean bl = matchFound = !EC2Utils.getMatchingIpPermissions(group, protocol, cidrIpRange, port).isEmpty();
        if (matchFound) {
            return;
        }
        IpPermission ipPermission = new IpPermission().withIpProtocol(protocol.getValue()).withFromPort(Integer.valueOf(port)).withToPort(Integer.valueOf(port)).withIpRanges(new String[]{cidrIpRange});
        AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest = new AuthorizeSecurityGroupIngressRequest().withGroupId(group.getGroupId()).withIpPermissions(new IpPermission[]{ipPermission});
        amazonEc2.authorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest);
    }
}

