/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

final class CallTimingProxy {
    private CallTimingProxy() {
    }

    @NotNull
    static <I, T extends I> I wrap(final T timedDelegate, Class<I> delegateInterface) {
        final Logger log = Logger.getLogger((String)("timed." + timedDelegate.getClass().getName()));
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                long start = System.currentTimeMillis();
                try {
                    log.trace((Object)("Invoking: " + method));
                    Object object = method.invoke(timedDelegate, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                finally {
                    long end = System.currentTimeMillis();
                    log.debug((Object)(method.getName() + " took " + (end - start) + "ms "));
                }
            }
        };
        return (I)Proxy.newProxyInstance(timedDelegate.getClass().getClassLoader(), new Class[]{delegateInterface}, handler);
    }
}

