/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.model;

import com.amazonaws.services.ec2.model.Subnet;
import com.atlassian.aws.ec2.model.ResourceId;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubnetId
extends ResourceId<SubnetId> {
    public static final SubnetId NO_SUBNET = new SubnetId(false);
    public static final Function<Subnet, String> GET_AZ = Subnet::getAvailabilityZone;

    public SubnetId(@NotNull String subnetId) {
        super(subnetId);
        Preconditions.checkArgument((boolean)subnetId.startsWith("subnet-"));
    }

    private SubnetId(boolean b) {
        super("");
    }

    public boolean isUndefined() {
        return this == NO_SUBNET;
    }

    @NotNull
    public static SubnetId from(@NotNull String subnetId) {
        return new SubnetId(subnetId);
    }

    @Nullable
    public static SubnetId fromNullable(@Nullable String subnetId) {
        return subnetId == null ? null : SubnetId.from(subnetId);
    }

    @NotNull
    public static SubnetId from(@NotNull Subnet subnet) {
        return SubnetId.from(subnet.getSubnetId());
    }

    @NotNull
    public static List<SubnetId> from(Collection<String> subnetIds) {
        return ResourceId.fromCollection(subnetIds, SubnetId::from);
    }
}

