/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceId<T> {
    private final String id;

    public ResourceId(@NotNull String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final String toString() {
        return this.id;
    }

    public final boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceId resourceId = (ResourceId)o;
        return this.id.equals(resourceId.id);
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public static <T> Iterable<T> from(Iterable<String> ids, Function<String, T> function) {
        return StreamSupport.stream(ids.spliterator(), false).map(arg_0 -> function.apply(arg_0)).collect(Collectors.toList());
    }

    @NotNull
    public static <T> List<T> fromCollection(Collection<String> ids, java.util.function.Function<String, T> function) {
        return ids.stream().map(function).collect(Collectors.toList());
    }

    @NotNull
    public static Collection<String> getIds(Iterable<? extends ResourceId<?>> resourceIds) {
        return StreamSupport.stream(resourceIds.spliterator(), false).map(ResourceId::getId).collect(Collectors.toList());
    }
}

