/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.model;

import com.amazonaws.services.ec2.model.Subnet;
import com.atlassian.aws.ec2.model.ResourceId;
import com.atlassian.aws.ec2.model.SubnetId;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class AvailabilityZoneId
extends ResourceId<AvailabilityZoneId> {
    private AvailabilityZoneId(String availabilityZoneId) {
        super(availabilityZoneId);
    }

    public static AvailabilityZoneId from(String availabilityZone) {
        return new AvailabilityZoneId(availabilityZone);
    }

    public static Iterable<AvailabilityZoneId> from(Iterable<String> availabilityZones) {
        return ResourceId.from(availabilityZones, AvailabilityZoneId::from);
    }

    public static Iterable<AvailabilityZoneId> fromSubnets(Iterable<Subnet> subnets) {
        List subnetIds = StreamSupport.stream(subnets.spliterator(), false).map(SubnetId.GET_AZ::apply).collect(Collectors.toList());
        return AvailabilityZoneId.from(new LinkedHashSet<String>(subnetIds));
    }
}

