/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.GetPasswordDataRequest;
import com.amazonaws.services.ec2.model.GetPasswordDataResult;
import com.atlassian.aws.ec2.model.InstanceId;
import com.atlassian.aws.utils.CryptoUtils;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstancePasswordCache {
    public static final String CIPHER_SPEC = "RSA/ECB/PKCS1Padding";
    private final LoadingCache<KeyInstanceIdHolder, String> instanceId2password;

    public InstancePasswordCache(@NotNull AmazonEC2Async ec2Client) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.instanceId2password = this.makePasswordComputingMap(ec2Client, this.makeCipherMap());
    }

    private LoadingCache<File, Cipher> makeCipherMap() {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<File, Cipher>(){

            public Cipher load(File keyFile) throws Exception {
                return CryptoUtils.getCipherForKey(keyFile, InstancePasswordCache.CIPHER_SPEC);
            }
        });
    }

    private LoadingCache<KeyInstanceIdHolder, String> makePasswordComputingMap(final AmazonEC2Async ec2Client, final LoadingCache<File, Cipher> key2cipher) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<KeyInstanceIdHolder, String>(){

            public String load(KeyInstanceIdHolder args) {
                GetPasswordDataRequest request = new GetPasswordDataRequest(args.getInstanceId().getId());
                GetPasswordDataResult passwordData = ec2Client.getPasswordData(request);
                String base64encodedPassword = passwordData.getPasswordData();
                if (StringUtils.isEmpty((CharSequence)base64encodedPassword)) {
                    throw new ComputationException((Throwable)new PasswordNotAvailableException("Password is not (yet) available. If password generation was enabled for this image, note that generation and encryption takes a few moments. Please wait up to 15 minutes after launching an instance before trying to retrieve the generated password."));
                }
                byte[] encodedPassword = Base64.getMimeDecoder().decode(base64encodedPassword);
                try {
                    Cipher cipherForKey = (Cipher)key2cipher.get((Object)args.getKeyFile());
                    return new String(cipherForKey.doFinal(encodedPassword));
                }
                catch (Exception e) {
                    throw new ComputationException((Throwable)e);
                }
            }
        });
    }

    @Nullable
    public String getPassword(File keyFile, InstanceId instanceId) {
        try {
            return (String)this.instanceId2password.get((Object)new KeyInstanceIdHolder(keyFile, instanceId));
        }
        catch (Exception e) {
            if (Throwables.getRootCause((Throwable)e) instanceof PasswordNotAvailableException) {
                return null;
            }
            throw new IllegalArgumentException(e);
        }
    }

    private static class KeyInstanceIdHolder {
        private final File keyFile;
        private final InstanceId instanceId;

        KeyInstanceIdHolder(File keyFile, InstanceId instanceId) {
            this.keyFile = keyFile;
            this.instanceId = instanceId;
        }

        public InstanceId getInstanceId() {
            return this.instanceId;
        }

        public File getKeyFile() {
            return this.keyFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyInstanceIdHolder that = (KeyInstanceIdHolder)o;
            if (!this.instanceId.equals(that.instanceId)) {
                return false;
            }
            return this.keyFile.equals(that.keyFile);
        }

        public int hashCode() {
            int result = this.keyFile.hashCode();
            result = 31 * result + this.instanceId.hashCode();
            return result;
        }
    }

    private static class PasswordNotAvailableException
    extends IllegalStateException {
        public PasswordNotAvailableException(String msg) {
            super(msg);
        }
    }
}

