/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.AmazonServiceException;
import com.atlassian.aws.AmazonServiceErrorCode;
import org.apache.log4j.Logger;

public class Ec2CacheMissException
extends AmazonServiceException {
    private static final Logger log = Logger.getLogger(Ec2CacheMissException.class);
    private static final String EC2_SERVICE_NAME = "AmazonEC2";

    public Ec2CacheMissException(String resourceId, AmazonServiceErrorCode errorCode) {
        super("The resource with ID '" + resourceId + "' does not exist");
        this.setErrorCode(errorCode.toString());
        this.setRequestId("none");
        this.setStatusCode(400);
        this.setErrorType(AmazonServiceException.ErrorType.Unknown);
        this.setServiceName(EC2_SERVICE_NAME);
    }
}

