/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.VirtualizationType;
import com.atlassian.aws.ec2.awssdk.Ec2Support;
import com.atlassian.aws.ec2.awssdk.RegionSupport;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsSupportConstants {
    public static final String ADDRESS_DOMAIN_VPC = "vpc";
    public static final Supplier<Map<String, Region>> LOCATION_CONSTRAINT_TO_REGION = Suppliers.memoize(() -> {
        ImmutableSet locationConstraintExceptions = ImmutableSet.of((Object)Region.US_EAST_1, (Object)Region.EU_WEST_1);
        ImmutableMap.Builder constraintMap = ImmutableMap.builder().put((Object)"US", (Object)Region.US_EAST_1).put((Object)"EU", (Object)Region.EU_WEST_1);
        for (Region region : Region.values()) {
            com.amazonaws.regions.Region sdkRegion;
            if (locationConstraintExceptions.contains((Object)region) || (sdkRegion = region.getSdkRegion()) == null) continue;
            constraintMap.put((Object)sdkRegion.getName(), (Object)region);
        }
        return constraintMap.build();
    });

    private AwsSupportConstants() {
    }

    @NotNull
    public static Region translateToRegion(@NotNull String region) {
        Region regionEnum = (Region)((Map)LOCATION_CONSTRAINT_TO_REGION.get()).get(region);
        if (region.equals("us-east-1")) {
            return Region.US_EAST_1;
        }
        return regionEnum != null ? regionEnum : (Region)AwsSupportConstants.translateToEnum((String)region, (NameProvider[])Region.values());
    }

    @NotNull
    private static <T extends NameProvider> T translateToEnum(@NotNull String name, T ... values) {
        for (T someEnum : values) {
            if (!someEnum.getName().equals(name)) continue;
            return someEnum;
        }
        throw new IllegalArgumentException("Unable to translate [" + name + "] to enum " + values.getClass());
    }

    public static class SpotInstanceRequestType {
        public static final String ONE_TIME = "one-time";

        private SpotInstanceRequestType() {
        }
    }

    public static enum SpotInstanceRequestState {
        OPEN("open"),
        ACTIVE("active"),
        CANCELLED("cancelled"),
        CLOSED("closed"),
        FAILED("failed");

        private final String stateName;

        private SpotInstanceRequestState(String stateName) {
            this.stateName = stateName;
        }

        public static boolean isFinal(@Nullable String state) {
            return CANCELLED.is(state) || CLOSED.is(state) || FAILED.is(state);
        }

        public boolean is(@Nullable String state) {
            return this.stateName.equals(state);
        }

        public String toString() {
            return this.stateName;
        }
    }

    public static enum SpotFleetRequestState {
        SUBMITTED("submitted"),
        ACTIVE("active"),
        CANCELLED("cancelled"),
        FAILED("failed"),
        CANCELLED_RUNNING("cancelled_running"),
        CANCELLED_TERMINATING("cancelled_terminating"),
        MODIFYING("modifying");

        private final String stateName;

        private SpotFleetRequestState(String stateName) {
            this.stateName = stateName;
        }

        public static boolean isFinal(@Nullable String state) {
            return CANCELLED.is(state) || FAILED.is(state) || CANCELLED_RUNNING.is(state) || CANCELLED_TERMINATING.is(state);
        }

        public boolean is(@Nullable String state) {
            return this.stateName.equals(state);
        }
    }

    public static enum InstanceStateName {
        SpotOpen(SpotInstanceRequestState.OPEN),
        SpotActive(SpotInstanceRequestState.ACTIVE),
        SpotCancelled(SpotInstanceRequestState.CANCELLED),
        SpotClosed(SpotInstanceRequestState.CLOSED),
        SpotFailed(SpotInstanceRequestState.FAILED),
        Pending(com.amazonaws.services.ec2.model.InstanceStateName.Pending),
        Running(com.amazonaws.services.ec2.model.InstanceStateName.Running),
        ShuttingDown(com.amazonaws.services.ec2.model.InstanceStateName.ShuttingDown),
        Terminated(com.amazonaws.services.ec2.model.InstanceStateName.Terminated),
        Stopping("stopping"),
        Stopped("stopped"),
        UNIDENTIFIED("unidentified");

        private final String state;

        private InstanceStateName(String state) {
            this.state = state;
        }

        private InstanceStateName(com.amazonaws.services.ec2.model.InstanceStateName state) {
            this.state = state.toString();
        }

        private InstanceStateName(SpotInstanceRequestState state) {
            this.state = state.stateName;
        }

        public String toString() {
            return this.state;
        }

        public static InstanceStateName fromValue(String value) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)value), (Object)"Value cannot be null or empty!");
            for (InstanceStateName name : InstanceStateName.values()) {
                if (!name.toString().equals(value)) continue;
                return name;
            }
            throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
        }

        public boolean is(@NotNull InstanceState state) {
            return this.state.equals(state.getName());
        }

        public static InstanceStateName fromValue(InstanceState state) {
            return InstanceStateName.fromValue(state.getName());
        }
    }

    public static enum InstanceAttribute {
        INSTANCE_INITIATED_SHUTDOWN_BEHAVIOUR("instanceInitiatedShutdownBehavior");

        private final String value;

        private InstanceAttribute(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum InstanceInitiatedShutdownBehaviour {
        STOP("stop"),
        TERMINATE("terminate");

        private final String behaviour;

        private InstanceInitiatedShutdownBehaviour(String behaviour) {
            this.behaviour = behaviour;
        }

        public String toString() {
            return this.behaviour;
        }
    }

    public static enum Region implements NameProvider
    {
        CA_CENTRAL_1(Regions.CA_CENTRAL_1, "Canada (Central)"),
        US_EAST_1(Regions.US_EAST_1, "US East (Northern Virginia)"),
        US_EAST_2(Regions.US_EAST_2, "US East (Ohio)"),
        US_WEST_1(Regions.US_WEST_1, "US West (Northern California)"),
        US_WEST_2(Regions.US_WEST_2, "US West (Oregon)"),
        EU_CENTRAL_1(Regions.EU_CENTRAL_1, "EU (Frankfurt)"),
        EU_WEST_1(Regions.EU_WEST_1, "EU (Ireland)"),
        EU_WEST_2(Regions.EU_WEST_2, "EU (London)"),
        ASIA_PACIFIC_SE_1(Regions.AP_SOUTHEAST_1, "Asia Pacific (Singapore)"),
        ASIA_PACIFIC_SE_2(Regions.AP_SOUTHEAST_2, "Asia Pacific (Sydney)"),
        ASIA_PACIFIC_NE_1(Regions.AP_NORTHEAST_1, "Asia Pacific (Tokyo)"),
        AP_NE_2(Regions.AP_NORTHEAST_2, "Asia Pacific (Seoul)"),
        AP_S_1(Regions.AP_SOUTH_1, "Asia Pacific (Mumbai)"),
        SOUTH_AMERICA_1(Regions.SA_EAST_1, "S\u00e3o Paulo"),
        US_GOV_W1(Regions.GovCloud, "GovCloud (US)"),
        CN_NORTH_1(Regions.CN_NORTH_1, "China (Beijing)"),
        CUSTOM("custom", "Custom", "custom");

        private final String name;
        private final String displayName;
        private final String endpoint;
        private final com.amazonaws.regions.Region region;

        private Region(@NotNull String name, String displayName, String endpoint) {
            this.name = name;
            this.displayName = displayName;
            this.endpoint = endpoint;
            this.region = null;
        }

        private Region(Regions region, String displayName) {
            this.region = RegionSupport.toRegion(region);
            this.name = RegionSupport.getNormalisedName(region);
            this.displayName = displayName;
            this.endpoint = Ec2Support.getEndpoint(region);
            if (this.endpoint == null) {
                throw new IllegalArgumentException("No endpoint found for region " + region);
            }
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getNormalisedName() {
            return this.name;
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public String getEndpoint() {
            return this.endpoint;
        }

        @Nullable
        public com.amazonaws.regions.Region getSdkRegion() {
            return this.region;
        }
    }

    public static enum RootDeviceType implements NameProvider
    {
        S3("s3"),
        EBS("ebs");

        private final String name;

        private RootDeviceType(String awsName) {
            this.name = awsName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public static RootDeviceType fromAwsName(@NotNull String awsName) {
            if (awsName.equalsIgnoreCase("instance-store")) {
                return S3;
            }
            return (RootDeviceType)AwsSupportConstants.translateToEnum((String)awsName, (NameProvider[])RootDeviceType.values());
        }
    }

    public static enum Virtualisation implements NameProvider
    {
        UNKNOWN(""),
        PV("pv"),
        HVM("hvm");

        private final String name;

        private Virtualisation(String virtualisationType) {
            this.name = virtualisationType;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public VirtualizationType toAws() {
            switch (this) {
                case HVM: {
                    return VirtualizationType.Hvm;
                }
                case PV: {
                    return VirtualizationType.Paravirtual;
                }
                case UNKNOWN: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Conversion from " + this + " not supported");
        }

        @NotNull
        public static Virtualisation fromAwsName(@NotNull String awsName) {
            if (awsName.equals("paravirtual")) {
                return PV;
            }
            return (Virtualisation)AwsSupportConstants.translateToEnum((String)awsName, (NameProvider[])Virtualisation.values());
        }
    }

    public static enum Platform implements NameProvider
    {
        linux("linux"),
        windows("windows");

        private final String name;

        private Platform(String awsName) {
            this.name = awsName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isWindows() {
            return StringUtils.containsIgnoreCase((CharSequence)this.name, (CharSequence)"windows");
        }

        @NotNull
        public static Platform fromAwsName(@NotNull String awsName) {
            return (Platform)AwsSupportConstants.translateToEnum((String)awsName, (NameProvider[])Platform.values());
        }
    }

    public static enum Architecture implements NameProvider
    {
        x86_64("x86_64"),
        i386("i386");

        private final String name;

        private Architecture(String awsName) {
            this.name = awsName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public static Architecture fromAwsName(@NotNull String awsName) {
            return (Architecture)AwsSupportConstants.translateToEnum((String)awsName, (NameProvider[])Architecture.values());
        }
    }

    public static interface NameProvider {
        public String getName();
    }
}

