/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotInstanceStateFault;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsInstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsSpotInstanceReservationDescription
implements InstanceReservationDescription {
    private static final Logger log = Logger.getLogger(AwsInstanceReservationDescription.class);
    private final SpotInstanceRequest spotInstanceRequest;

    public AwsSpotInstanceReservationDescription(SpotInstanceRequest spotInstanceRequest) {
        this.spotInstanceRequest = spotInstanceRequest;
    }

    @NotNull
    public static Collection<InstanceReservationDescription> create(@NotNull Collection<SpotInstanceRequest> spotInstanceRequests) {
        return Collections2.transform(spotInstanceRequests, (Function)new Function<SpotInstanceRequest, InstanceReservationDescription>(){

            public InstanceReservationDescription apply(SpotInstanceRequest spotInstanceRequest) {
                return new AwsSpotInstanceReservationDescription(spotInstanceRequest);
            }
        });
    }

    @Override
    public String getInstanceId() {
        return this.spotInstanceRequest.getInstanceId();
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequest.getSpotInstanceRequestId();
    }

    @Override
    public String getAvailabilityZone() {
        return this.spotInstanceRequest.getLaunchedAvailabilityZone();
    }

    @Override
    @Nullable
    public SubnetId getSubnet() {
        return SubnetId.fromNullable(this.spotInstanceRequest.getLaunchSpecification().getSubnetId());
    }

    @Override
    @NotNull
    public String getAddress() {
        return "none";
    }

    @Override
    @Nullable
    public InstanceType getInstanceType() {
        return InstanceType.fromValue((String)this.spotInstanceRequest.getLaunchSpecification().getInstanceType());
    }

    @Override
    @NotNull
    public String getHostname() {
        return "none";
    }

    @Override
    public AwsSupportConstants.InstanceStateName getState() {
        return AwsSupportConstants.InstanceStateName.fromValue(this.spotInstanceRequest.getState());
    }

    @Override
    public String getStateDescription() {
        SpotInstanceStateFault fault = this.spotInstanceRequest.getFault();
        String description = this.spotInstanceRequest.getState();
        if (fault != null) {
            return description + ", fault: " + fault;
        }
        return description;
    }
}

