/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Reservation;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.SubnetId;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsInstanceReservationDescription
implements InstanceReservationDescription {
    private final Instance instance;

    public AwsInstanceReservationDescription(Instance instance) {
        this.instance = instance;
    }

    @NotNull
    public static Collection<InstanceReservationDescription> create(Reservation reservation) {
        return reservation.getInstances().stream().map(AwsInstanceReservationDescription::new).collect(Collectors.toList());
    }

    @Override
    public String getInstanceId() {
        return this.instance.getInstanceId();
    }

    @Override
    public String getAvailabilityZone() {
        return this.instance.getPlacement().getAvailabilityZone();
    }

    @Override
    @Nullable
    public SubnetId getSubnet() {
        return SubnetId.fromNullable(this.instance.getSubnetId());
    }

    @Override
    @NotNull
    public String getAddress() {
        String publicIpAddress = this.instance.getPublicIpAddress();
        if (StringUtils.isNotBlank((CharSequence)publicIpAddress)) {
            return publicIpAddress;
        }
        return this.instance.getPrivateIpAddress();
    }

    @Override
    @Nullable
    public InstanceType getInstanceType() {
        return InstanceType.fromValue((String)this.instance.getInstanceType());
    }

    @Override
    @NotNull
    public String getHostname() {
        String publicDnsName = this.instance.getPublicDnsName();
        if (StringUtils.isNotBlank((CharSequence)publicDnsName)) {
            return publicDnsName;
        }
        String publicIpAddress = this.instance.getPublicIpAddress();
        if (StringUtils.isNotBlank((CharSequence)publicIpAddress)) {
            return publicIpAddress;
        }
        String privateDnsName = this.instance.getPrivateDnsName();
        if (StringUtils.isNotBlank((CharSequence)privateDnsName)) {
            return privateDnsName;
        }
        return this.instance.getPrivateIpAddress();
    }

    @Override
    public AwsSupportConstants.InstanceStateName getState() {
        return AwsSupportConstants.InstanceStateName.fromValue(this.instance.getState().getName());
    }

    @Override
    public String getStateDescription() {
        InstanceState state = this.instance.getState();
        return state.getName() + " (" + state.getCode() + ") for reason [" + this.instance.getStateTransitionReason() + "]";
    }
}

