/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.SpotPrice;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SpotPriceMatrix {
    private static final Logger log = Logger.getLogger(SpotPriceMatrix.class);
    private final Map<String, EnumMap<InstanceType, Price>> spotPriceMap = new TreeMap<String, EnumMap<InstanceType, Price>>();

    public SpotPriceMatrix() {
    }

    public SpotPriceMatrix(List<SpotPrice> spotPrices) {
        this.add(spotPrices);
    }

    public void add(SpotPrice spotPrice) {
        String product = spotPrice.getProductDescription();
        try {
            InstanceType instanceType = InstanceType.fromValue((String)spotPrice.getInstanceType());
            Double price = Double.valueOf(spotPrice.getSpotPrice());
            this.add(product, instanceType, new Price(price, spotPrice.getTimestamp()));
        }
        catch (IllegalArgumentException ignored) {
            log.debug((Object)("Skipping spot price for " + spotPrice.getInstanceType()));
        }
    }

    public void add(String product, InstanceType instanceType, double bid) {
        this.add(product, instanceType, new Price(bid));
    }

    public void add(String product, InstanceType instanceType, Price spotPrice) {
        EnumMap<InstanceType, Price> instancesPricesForProduct = this.spotPriceMap.get(product);
        if (instancesPricesForProduct == null) {
            instancesPricesForProduct = new EnumMap(InstanceType.class);
            this.spotPriceMap.put(product, instancesPricesForProduct);
        }
        instancesPricesForProduct.put(instanceType, spotPrice);
    }

    public void add(Iterable<SpotPrice> spotPrices) {
        for (SpotPrice spotPrice : spotPrices) {
            this.add(spotPrice);
        }
    }

    @Nullable
    public Price getPrice(String product, InstanceType instanceType) {
        Map productPrice = this.spotPriceMap.get(product);
        if (productPrice == null) {
            return null;
        }
        return (Price)productPrice.get(instanceType);
    }

    public Collection<String> getProducts() {
        return this.spotPriceMap.keySet();
    }

    public static class Price {
        private final Date timestamp;
        private final double spotPrice;

        public Price(double spotPrice) {
            this(spotPrice, new Date());
        }

        public Price(double spotPrice, Date timestamp) {
            this.timestamp = timestamp;
            this.spotPrice = spotPrice;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public double getSpotPrice() {
            return this.spotPrice;
        }

        public String toString() {
            return String.valueOf(this.spotPrice);
        }
    }
}

