/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.model.SecurityGroupId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceLaunchConfigurationBuilder {
    private String keyName;
    private Object userData;
    private double spotInstanceBid = -1.0;
    private Iterable<EC2InstanceType> instanceType;
    private String imageId;
    private Iterable<String> requestedAvailabilityZone;
    private int startupTimeoutSeconds;
    private Collection<String> availableSubnetIds;
    private int spotRequestTimeoutSeconds = 300;
    private IamInstanceProfileSpecification iamInstanceProfile;
    private boolean isEbsOptimised;
    private String ebsSnapshotId;
    private boolean shouldAssociatePublicIp;
    private ImmutableMultimap<SubnetId, SecurityGroupId> availableSecurityGroups;

    @NotNull
    public InstanceLaunchConfiguration build() {
        return new InstanceLaunchConfiguration(this.imageId, this.keyName, this.availableSecurityGroups, this.requestedAvailabilityZone, this.startupTimeoutSeconds, this.availableSubnetIds, this.spotRequestTimeoutSeconds, this.userData, this.spotInstanceBid, this.instanceType, this.iamInstanceProfile, this.ebsSnapshotId, this.isEbsOptimised, this.shouldAssociatePublicIp);
    }

    public InstanceLaunchConfigurationBuilder withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withAvailableSecurityGroups(Multimap<SubnetId, SecurityGroupId> availableSecurityGroups) {
        this.availableSecurityGroups = ImmutableMultimap.copyOf(availableSecurityGroups);
        return this;
    }

    public InstanceLaunchConfigurationBuilder withUserData(Object userData) {
        this.userData = userData;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withInstanceTypes(Iterable<EC2InstanceType> instanceTypes) {
        this.instanceType = instanceTypes;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withAvailabilityZone(@Nullable Iterable<String> availabilityZone) {
        this.requestedAvailabilityZone = (Iterable)MoreObjects.firstNonNull((Object)ImmutableList.copyOf(availabilityZone), Collections.emptyList());
        return this;
    }

    public InstanceLaunchConfigurationBuilder withStartupTimeoutSeconds(int startupTimeoutSeconds) {
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withSpotInstanceBid(double spotInstanceBid) {
        this.spotInstanceBid = spotInstanceBid;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withSpotRequestTimeoutSeconds(int spotRequestTimeoutSeconds) {
        this.spotRequestTimeoutSeconds = spotRequestTimeoutSeconds;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withAvailableSubnetIds(@NotNull Iterable<String> availableSubnetIds) {
        this.availableSubnetIds = ImmutableList.copyOf(availableSubnetIds);
        return this;
    }

    public InstanceLaunchConfigurationBuilder withIamInstanceProfile(@Nullable String iamInstanceProfileArnOrName) {
        if (iamInstanceProfileArnOrName == null) {
            return this;
        }
        IamInstanceProfileSpecification profile = new IamInstanceProfileSpecification();
        if (iamInstanceProfileArnOrName.startsWith("arn:aws:iam")) {
            profile.setArn(iamInstanceProfileArnOrName);
        } else {
            profile.setName(iamInstanceProfileArnOrName);
        }
        this.iamInstanceProfile = profile;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withEbsSnapsthotId(String ebsSnapsthotId) {
        this.ebsSnapshotId = ebsSnapsthotId;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withEbsOptimised(boolean isEbsOptimised) {
        this.isEbsOptimised = isEbsOptimised;
        return this;
    }

    public InstanceLaunchConfigurationBuilder withShouldAssociatePublicIp(boolean shouldAssociatePublicIp) {
        this.shouldAssociatePublicIp = shouldAssociatePublicIp;
        return this;
    }
}

