/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.util.EC2MetadataUtils;
import com.atlassian.aws.ec2.EC2Instance;
import com.atlassian.aws.ec2.Ec2UtilsThin;
import com.atlassian.aws.ec2.Protocol;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.EC2Image;
import com.atlassian.aws.ec2.configuration.EC2ImageImpl;
import com.atlassian.aws.utils.CompressionUtils;
import com.atlassian.aws.utils.JsonUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EC2Utils {
    private static boolean isCompressionEnabled = false;

    private EC2Utils() {
    }

    @NotNull
    public static EC2Instance getLocalEC2Instance() throws IOException {
        return Ec2UtilsThin.getLocalEC2Instance();
    }

    public static <T> T getUserData(Class<T> aClass) throws IOException, ClassNotFoundException {
        return (T)Ec2UtilsThin.getUserData(aClass);
    }

    public static EC2Image getCurrentImage() throws IOException {
        return new EC2ImageImpl(EC2MetadataUtils.getAmiId());
    }

    @Contract(value="!null -> !null")
    public static String getUserDataAsString(Object userData) {
        if (userData == null) {
            return null;
        }
        return EC2Utils.toUserDataString(userData);
    }

    private static String toUserDataString(Object userData) {
        String userDataJson = JsonUtils.toJson((Object)userData);
        byte[] userDataJsonBytes = userDataJson.getBytes(StandardCharsets.UTF_8);
        if (!isCompressionEnabled) {
            userDataJsonBytes = CompressionUtils.compress((byte[])userDataJsonBytes);
        }
        return Base64.getMimeEncoder().encodeToString(userDataJsonBytes);
    }

    @Deprecated
    static void enableCompresssion() {
        isCompressionEnabled = true;
    }

    @Deprecated
    public static void disableCompresssion() {
        isCompressionEnabled = false;
    }

    public static boolean isWindows(@NotNull Image image) {
        String platform = image.getPlatform();
        return platform != null && AwsSupportConstants.Platform.fromAwsName(platform).isWindows();
    }

    @NotNull
    public static List<IpPermission> getMatchingIpPermissions(@NotNull SecurityGroup group, @NotNull Protocol protocol, @Nullable String cidrIpRange, int port) {
        ArrayList<IpPermission> ipPermissions = new ArrayList<IpPermission>();
        for (IpPermission permission : group.getIpPermissions()) {
            boolean cidrMatches;
            boolean protocolMatches = permission.getIpProtocol().equalsIgnoreCase(protocol.getValue());
            if (!protocolMatches) continue;
            int fromPort = (Integer)MoreObjects.firstNonNull((Object)permission.getFromPort(), (Object)-1);
            int toPort = (Integer)MoreObjects.firstNonNull((Object)permission.getToPort(), (Object)-1);
            boolean portMatches = fromPort <= port && port <= toPort;
            boolean bl = cidrMatches = cidrIpRange == null || permission.getIpRanges().contains(cidrIpRange);
            if (!portMatches || !cidrMatches) continue;
            ipPermissions.add(permission);
        }
        return ipPermissions;
    }

    public static String getEbsDeviceName(@NotNull Image image) {
        return EC2Utils.isWindows(image) ? "xvdh" : "/dev/sdh";
    }

    public static byte[] parseFingerprint(@NotNull String fingerprintString) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fingerprintString));
        StringTokenizer stringTokenizer = new StringTokenizer(fingerprintString, ":");
        byte[] bytes = new byte[stringTokenizer.countTokens()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
        }
        return bytes;
    }

    public static boolean isKeyMatching(@NotNull PEMKeyPair keypair, @NotNull byte[] awsFingerprint) throws IOException {
        byte[] local;
        if (awsFingerprint.length == 16) {
            SubjectPublicKeyInfo publicKeyInfo = keypair.getPublicKeyInfo();
            local = DigestUtils.md5((byte[])publicKeyInfo.getEncoded());
        } else if (awsFingerprint.length == 20) {
            PrivateKeyInfo privateKeyInfo = keypair.getPrivateKeyInfo();
            local = EC2Utils.sha1(privateKeyInfo.getEncoded());
        } else {
            throw new IllegalArgumentException("Unknown fingerprint format " + Arrays.toString(awsFingerprint));
        }
        return Arrays.equals(local, awsFingerprint);
    }

    @VisibleForTesting
    static byte[] sha1(byte[] encoded) {
        try {
            return MessageDigest.getInstance("SHA-1").digest(encoded);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

