/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.VirtualizationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum EC2InstanceType {
    M3Medium(InstanceType.M3Medium, "M3 General Purpose Medium", 0, 1, "3.75 GiB RAM, 1 vCPU, 3 EC2 Compute Units, 4 GB of SSD-based local instance storage", "Network Performance: Moderate"),
    M3Large(InstanceType.M3Large, "M3 General Purpose Large", 0, 1, "7.5 GiB RAM, 2 VCPUs, 6.5 EC2 Compute Units, 32 GB of SSD-based local instance storage", "Network Performance: Moderate"),
    M3Xlarge(InstanceType.M3Xlarge, "M3 General Purpose Extra Large", 0, 2, "13 EC2 Compute Units (4 virtual cores with 3.25 EC2 Compute Units each)", "15 GiB memory", "Network Performance: High", "EBS-Optimized Available: No"),
    M32xlarge(InstanceType.M32xlarge, "M3 General Purpose 2 Extra Large", 0, 2, "26 EC2 Compute Units (8 virtual cores with 3.25 EC2 Compute Units each)", "30 GiB memory", "Network Performance: High", "EBS-Optimized Available: No"),
    M4Large(InstanceType.M4Large, "M4 General Purpose Large", 0, 0, "8 GiB RAM, 2 vCPUs, Network Bandwidth: Moderate"),
    M4Xlarge(InstanceType.M4Xlarge, "M4 General Purpose Extra Large", 0, 0, "16 GiB RAM, 4 vCPUs, Network Bandwidth: High"),
    M42xlarge(InstanceType.M42xlarge, "M4 General Purpose 2 Extra Large", 0, 0, "32 GiB RAM, 8 vCPUs, Network Bandwidth: High"),
    M44xlarge(InstanceType.M44xlarge, "M4 General Purpose 4 Extra Large", 0, 0, "64 GiB RAM, 16 vCPUs, Network Bandwidth: High"),
    M410xlarge(InstanceType.M410xlarge, "M4 General Purpose 10 Extra Large", 0, 0, "160 GiB RAM, 40 vCPUs, Network Bandwidth: 10 Gbps"),
    M416xlarge(InstanceType.M416xlarge, "M4 General Purpose 16 Extra Large", 0, 0, "256 GiB RAM, 64 vCPUs, Network Bandwidth: 20 Gbps"),
    M1_SMALL(InstanceType.M1Small, "M1 Old General Purpose Small", 1, 0, "1 EC2 Compute Unit (1 virtual core with 1 EC2 Compute Unit)", "1.7 GiB memory", "160 GB instance storage", "32-bit or 64-bit platform", "Network Performance: Low", "EBS-Optimized Available: No"),
    M1Medium(InstanceType.M1Medium, "M1 Old General Purpose Medium", 1, 0, "3.75 GiB memory", "M1 Medium Instance", "2 EC2 Compute Unit (1 virtual core with 2 EC2 Compute Unit)", "410 GB instance storage", "32-bit or 64-bit platform", "Network Performance: Moderate", "EBS-Optimized Available: No"),
    M1_LARGE(InstanceType.M1Large, "M1 Old General Purpose Large", 2, 0, "4 EC2 Compute Units (2 virtual cores with 2 EC2 Compute Units each)", "7.5 GiB memory", "850 GB instance storage", "Network Performance: Moderate", "EBS-Optimized Available: 500 Mbps"),
    M1_XLARGE(InstanceType.M1Xlarge, "M1 Old General Purpose Extra Large", 4, 0, "15 GiB memory", "M1 Extra Large Instance", "8 EC2 Compute Units (4 virtual cores with 2 EC2 Compute Units each)", "1,690 GB instance storage", "Network Performance: High", "EBS-Optimized Available: 1000 Mbps"),
    T1Micro(InstanceType.T1Micro, "T1 Old Burstable Performance Micro", 0, 0, "1 vCPU", "0.6131 GiB RAM", "32-bit or 64-bit platform"),
    T2Nano(InstanceType.T2Nano, "T2 Burstable Performance Nano", 0, 0, "1 vCPU", "0.5 GiB RAM", "32-bit or 64-bit platform"),
    T2Micro(InstanceType.T2Micro, "T2 Burstable Performance Micro", 0, 0, "1 vCPU", "1 GiB RAM", "32-bit or 64-bit platform"),
    T2Small(InstanceType.T2Small, "T2 Burstable Performance Small", 0, 0, "1 vCPU", "2 GiB RAM", "32-bit or 64-bit platform"),
    T2Medium(InstanceType.T2Medium, "T2 Burstable Performance Medium", 0, 0, "2 vCPU", "4 GiB RAM"),
    T2Large(InstanceType.T2Large, "T2 Burstable Performance Large", 0, 0, "2 vCPU", "8 GiB RAM"),
    T2Xlarge(InstanceType.T2Xlarge, "T2 Burstable Performance Extra Large", 0, 0, "4 vCPU", "16 GiB RAM"),
    T22xlarge(InstanceType.T22xlarge, "T2 Burstable Performance 2 Extra Large", 0, 0, "8 vCPU", "32 GiB RAM"),
    C3Large(InstanceType.C3Large, "C3 Compute Optimised Large", 0, 2, "3.75 GiB RAM, 2 vCPUs, 7 EC2 Compute Units, 32 GB of SSD-based local instance storage"),
    C3Xlarge(InstanceType.C3Xlarge, "C3 Compute Optimised Extra Large", 0, 2, "7 GiB RAM, 4 vCPUs, 14 EC2 Compute Units, 80 GB of SSD-based local instance storage"),
    C32xlarge(InstanceType.C32xlarge, "C3 Compute Optimised 2 Extra Large", 0, 2, "15 GiB RAM, 8 vCPUs, 28 EC2 Compute Units, 160 GB of SSD-based local instance storage"),
    C34xlarge(InstanceType.C34xlarge, "C3 Compute Optimised 4 Extra Large", 0, 2, "30 GiB RAM, 16 vCPUs, 55 EC2 Compute Units, 320 GB of SSD-based local instance storage"),
    C38xlarge(InstanceType.C38xlarge, "C3 Compute Optimised 8 Extra Large", 0, 2, "60 GiB RAM, 32 vCPUs, 108 EC2 Compute Units, 640 GB of SSD-based local instance storage"),
    C1_MEDIUM(InstanceType.C1Medium, "C1 Old Compute Optimised Medium", 1, 0, "5 EC2 Compute Units (2 virtual cores with 2.5 EC2 Compute Units each)", "1.7 GiB RAM", "350 GB of instance storage", "32-bit or 64-bit platform", "Network Performance: Moderate", "EBS-Optimized Available: No"),
    C1_XLARGE(InstanceType.C1Xlarge, "C1 Old Compute Optimised Extra Large", 4, 0, "20 EC2 Compute Units (8 virtual cores with 2.5 EC2 Compute Units each)", "7 GiB RAM", "1690 GB of instance storage", "Network Performance: High", "EBS-Optimized Available: No"),
    Cc28xlarge(InstanceType.Cc28xlarge, "CC2 Old Cluster Compute Optimised 8 Extra Large", 4, 0, "88 EC2 Compute Units (2 x Intel Xeon E5-2670, eight-core)", "60.5 GiB RAM", "3370 GB of instance storage", "Network Bandwidth: 10 Gbps)", "EBS-Optimized Available: No"),
    C4Large(InstanceType.C4Large, "C4 Compute Optimised Large", 0, 0, "3.75 GiB RAM, 2 vCPUs"),
    C4Xlarge(InstanceType.C4Xlarge, "C4 Compute Optimised Extra Large", 0, 0, "7.5 GiB RAM, 4 vCPUs"),
    C42xlarge(InstanceType.C42xlarge, "C4 Compute Optimised Double Large", 0, 0, "15 GiB RAM, 8 vCPUs"),
    C44xlarge(InstanceType.C44xlarge, "C4 Compute Optimised Quadruple Large", 0, 0, "30 GiB RAM, 16 vCPUs"),
    C48xlarge(InstanceType.C48xlarge, "C4 Compute Optimised Eight Large", 0, 0, "60 GiB RAM, 36 vCPUs"),
    F12xlarge(InstanceType.F12xlarge, "F1 FPGA instance 2 Extra Large", 0, 1, "1 FPGA", "8 vCPUs", "122 GiB RAM"),
    F116xlarge(InstanceType.F116xlarge, "F1 FPGA instance 16 Extra Large", 0, 4, "8 FPGA", "64 vCPUs", "976 GiB RAM"),
    G22xlarge(InstanceType.G22xlarge, "G2 GPU 2 Extra Large", 0, 1, "15 GiB memory, 26 EC2 Compute Units, 1 x NVIDIA GRID GPU (Kepler GK104), 60 GB of local instance storage"),
    G28xlarge(InstanceType.G28xlarge, "G2 GPU 8 Extra Large", 0, 2, "60 GiB memory, 32 vCPUs, 4 x NVIDIA GPU, 240 GB of local instance storage"),
    G34xlarge(InstanceType.G34xlarge, "G3 GPU 4 Extra Large", 0, 0, "122 GiB memory", "16 vCPUs", "1 x NVIDIA GPU", "Network Bandwidth: <10 Gbps"),
    G38xlarge(InstanceType.G38xlarge, "G3 GPU 8 Extra Large", 0, 0, "244 GiB memory", "32 vCPUs", "2 x NVIDIA GPU", "Network Bandwidth: 10 Gbps"),
    G316xlarge(InstanceType.G316xlarge, "G3 GPU 16 Extra Large", 0, 0, "488 GiB memory", "64 vCPUs", "4 x NVIDIA GPU", "Network Bandwidth: 20 Gbps"),
    Cg14xlarge(InstanceType.Cg14xlarge, "CG1 Old GPU 4 Extra Large", 2, 0, "33.5 EC2 Compute Units (2 x Intel Xeon X5570, quad-core)", "22 GiB RAM", "2 x NVIDIA Tesla Fermi M2050 GPUs", "1690 GB of instance storage", "Network Bandwidth: 10 Gbps", "EBS-Optimized Available: No"),
    P2Xlarge(InstanceType.P2Xlarge, "P2 Accelerated Computing Large", 0, 0, "61 GiB RAM, 4 vCPUs, 1 GPU, Network Bandwidth: High"),
    P28xlarge(InstanceType.P28xlarge, "P2 Accelerated Computing 8x Large", 0, 0, "488 GiB RAM, 32 vCPUs, 8 GPU, Network Bandwidth: 10 Gbps"),
    P216xlarge(InstanceType.P216xlarge, "P2 Accelerated Computing 16x Large", 0, 0, "732 GiB RAM, 64 vCPUs, 16 GPU, Network Bandwidth: 20 Gbps"),
    R3Large(InstanceType.R3Large, "R3 Memory Optimised Large", 0, 1, "2 vCPUs", "15 GiB RAM", "1 x 32 GB of SSD-based instance storage"),
    R3XLarge(InstanceType.R3Xlarge, "R3 Memory Optimised Extra Large", 0, 1, "4 vCPUs", "30.5 GiB RAM", "1 x 80 GB of SSD-based instance storage"),
    R32xlarge(InstanceType.R32xlarge, "R3 Memory Optimised 2 Extra Large", 0, 1, "8 vCPUs", "61 GiB RAM", "1 x 160 GB of SSD-based instance storage"),
    R34xlarge(InstanceType.R34xlarge, "R3 Memory Optimised 4 Extra Large", 0, 1, "16 vCPUs", "122 GiB RAM", "1 x 320 GB of SSD-based instance storage"),
    R38xlarge(InstanceType.R38xlarge, "R3 Memory Optimised 8 Extra Large", 0, 2, "32 vCPUs", "244 GiB RAM", "2 x 320 GB of SSD-based instance storage", "Network Bandwidth: 10 Gbps"),
    R4Large(InstanceType.R4Large, "R4 Memory Optimised Large", 0, 0, "2 vCPUs", "15.25 GiB RAM", "Network Bandwidth: <10 Gbps"),
    R4Xlarge(InstanceType.R4Xlarge, "R4 Memory Optimised Extra Large", 0, 0, "4 vCPUs", "30.5 GiB RAM", "Network Bandwidth: <10 Gbps"),
    R42xlarge(InstanceType.R42xlarge, "R4 Memory Optimised 2 Extra Large", 0, 0, "8 vCPUs", "61 GiB RAM", "Network Bandwidth: <10 Gbps"),
    R44xlarge(InstanceType.R44xlarge, "R4 Memory Optimised 4 Extra Large", 0, 0, "16 vCPUs", "122 GiB RAM", "Network Bandwidth: <10 Gbps"),
    R48xlarge(InstanceType.R48xlarge, "R4 Memory Optimised 8 Extra Large", 0, 0, "32 vCPUs", "244 GiB RAM", "Network Bandwidth: 10 Gbps"),
    R416xlarge(InstanceType.R416xlarge, "R4 Memory Optimised 16 Extra Large", 0, 0, "64 vCPUs", "488 GiB RAM", "Network Bandwidth: 20 Gbps"),
    M2Xlarge(InstanceType.M2Xlarge, "M2 Old Memory Optimised Extra Large", 1, 0, "6.5 EC2 Compute Units (2 virtual cores with 3.25 EC2 Compute Units each)", "17.1 GiB RAM", "420 GB of instance storage", "Network Performance: Moderate", "EBS-Optimized Available: No"),
    M22xlarge(InstanceType.M22xlarge, "M2 Old Memory Optimised 2 Extra Large", 1, 0, "13 EC2 Compute Units (4 virtual cores with 3.25 EC2 Compute Units each)", "34.2 GiB RAM", "850 GB of instance storage", "Network Performance: Moderate", "EBS-Optimized Available: No"),
    M24xlarge(InstanceType.M24xlarge, "M2 Old Memory Optimised 4 Extra Large", 2, 0, "26 EC2 Compute Units (8 virtual cores with 3.25 EC2 Compute Units each)", "68.4 GiB RAM", "1690 GB of instance storage", "Network Performance: High", "EBS-Optimized Available: 1000 Mbps"),
    Cr18xlarge(InstanceType.Cr18xlarge, "CR1 Old Memory Optimised Cluster 8 Extra Large", 0, 2, "88 EC2 Compute Units (2 x Intel Xeon E5-2670, eight-core. Intel Turbo, NUMA)", "244 GiB RAM", "240 GB of SSD instance storage", "Network Performance: 10 Gbps", "EBS-Optimized Available: No"),
    I2Xlarge(InstanceType.I2Xlarge, "I2 Storage Optimised Extra Large", 0, 1, "30.5 GiB RAM, 4 vCPUs, 14 EC2 Compute Units, 800 GB of SSD-based instance storage"),
    I22xlarge(InstanceType.I22xlarge, "I2 Storage Optimised 2 Extra Large", 0, 2, "61 GiB RAM, 8 vCPUs, 27 EC2 Compute Units, 2 x 800 GB of SSD-based instance storage"),
    I24xlarge(InstanceType.I24xlarge, "I2 Storage Optimised 4 Extra Large", 0, 4, "122 GiB RAM, 16 vCPUs, 53 EC2 Compute Units, 4 x 800 GB of SSD-based instance storage"),
    I28xlarge(InstanceType.I28xlarge, "I2 Storage Optimised 8 Extra Large", 0, 8, "244 GiB RAM, 32 vCPUs, 104 EC2 Compute Units, 8 x 800 GB of SSD-based instance storage, Network Bandwidth: 10 Gbps"),
    I3Large(InstanceType.I3Large, "I3 Storage Optimised Large", 0, 1, "15.25 GiB RAM", "2 vCPUs", "Network Bandwidth: <10 Gbps"),
    I3Xlarge(InstanceType.I3Xlarge, "I3 Storage Optimised Extra Large", 0, 1, "30.5 GiB RAM", "4 vCPUs", "Network Bandwidth: <10 Gbps"),
    I32xlarge(InstanceType.I32xlarge, "I3 Storage Optimised 2 Extra Large", 0, 1, "61 GiB RAM", "8 vCPUs", "Network Bandwidth: <10 Gbps"),
    I34xlarge(InstanceType.I34xlarge, "I3 Storage Optimised 4 Extra Large", 0, 2, "122 GiB RAM", "16 vCPUs", "Network Bandwidth: <10 Gbps"),
    I38xlarge(InstanceType.I38xlarge, "I3 Storage Optimised 8 Extra Large", 0, 4, "244 GiB RAM", "32 vCPUs", "Network Bandwidth: 10 Gbps"),
    I316xlarge(InstanceType.I316xlarge, "I3 Storage Optimised 16 Extra Large", 0, 8, "488 GiB RAM", "64 vCPUs", "Network Bandwidth: 20 Gbps"),
    D2Xlarge(InstanceType.D2Xlarge, "D2 Dense Storage Optimised Extra Large", 3, 0, "14 EC2 Compute Units (4 virtual cores)", "30.5 GiB RAM", "Network Bandwidth: Moderate", "EBS-Optimized Available: By Default"),
    D22xlarge(InstanceType.D22xlarge, "D2 Dense Storage Optimised 2 Extra Large", 6, 0, "28 EC2 Compute Units (8 virtual cores)", "61 GiB RAM", "Network Bandwidth: High", "EBS-Optimized Available: By Default"),
    D24xlarge(InstanceType.D24xlarge, "D2 Dense Storage Optimised Quarduple Extra Large", 12, 0, "56 EC2 Compute Units (16 virtual cores)", "122 GiB RAM", "Network Bandwidth: High", "EBS-Optimized Available: By Default"),
    D28xlarge(InstanceType.D28xlarge, "D2 Dense Storage Optimised 8 Extra Large", 36, 0, "116 EC2 Compute Units (36 virtual cores)", "244 GiB RAM", "Network Bandwidth: 10 Gbps", "EBS-Optimized Available: By Default"),
    Hs18xlarge(InstanceType.Hs18xlarge, "HS1 Storage Optimised 8 Extra Large", 24, 0, "35 EC2 Compute Units (16 virtual cores)", "117 GiB RAM", "24 hard disk drives each with 2 TB of instance storage", "Network Bandwidth: 10 Gbps", "Storage I/O Performance: Very High", "EBS-Optimized Available: No"),
    Hi14xlarge(InstanceType.Hi14xlarge, "HI1 Old Storage Optimised 4 Extra Large", 0, 2, "35 EC2 Compute Units (16 virtual cores)", "60.5 GiB RAM", "2 SSD-based volumes each with 1024 GB of instance storage", "Network Bandwidth: 10 Gbps", "Storage I/O Performance: Very High", "EBS-Optimized Available: No"),
    X116xlarge(InstanceType.X116xlarge, "X1 Memory Optimised 16 Extra Large", 0, 2, "? vCPUs", "? GiB RAM", "? GB of SSD-based instance storage", "Network Bandwidth: 10 Gbps Ethernet", "EBS-Optimized Available: By Default"),
    X132xlarge(InstanceType.X132xlarge, "X1 Memory Optimised 32 Extra Large", 0, 2, "128 vCPUs", "1952 GiB RAM", "2 x 1920 GB of SSD-based instance storage", "Network Bandwidth: 10 Gbps Ethernet", "EBS-Optimized Available: By Default");

    public static final EC2InstanceType DEFAULT;
    private final String name;
    private final int ssdCnt;
    private final int magneticDiscCnt;
    private String description;
    private final InstanceType apiParameterValue;
    @VisibleForTesting
    final String family;
    @VisibleForTesting
    static final Set<String> oldGeneration;
    @VisibleForTesting
    static final Set<String> currentGeneration;
    @VisibleForTesting
    static final Set<String> currentGenerationWithPv;
    @VisibleForTesting
    static final Set<String> oldGenerationWithPv;
    @VisibleForTesting
    static final Set<String> oldGenerationWithHvm;

    private EC2InstanceType(InstanceType apiParameterValue, String name, int magneticDiscCnt, int ssdCnt, String ... descriptionLines) {
        this.name = name;
        this.ssdCnt = ssdCnt;
        this.magneticDiscCnt = magneticDiscCnt;
        this.description = descriptionLines.length > 1 ? Joiner.on((char)'\n').join((Object[])descriptionLines) : StringUtils.replace((String)descriptionLines[0], (String)",", (String)"\n");
        if (ssdCnt == 0 && magneticDiscCnt == 0) {
            this.description = this.description + "\nEBS only";
        }
        this.apiParameterValue = apiParameterValue;
        this.family = StringUtils.substringBefore((String)apiParameterValue.toString(), (String)".").toUpperCase();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSsdCnt() {
        return this.ssdCnt;
    }

    public InstanceType getAwsInstanceType() {
        return this.apiParameterValue;
    }

    public boolean supports(VirtualizationType virtualisation) {
        switch (virtualisation) {
            case Hvm: {
                return currentGeneration.contains(this.family) || oldGenerationWithHvm.contains(this.family);
            }
            case Paravirtual: {
                return currentGenerationWithPv.contains(this.family) || oldGenerationWithPv.contains(this.family);
            }
        }
        throw new UnsupportedOperationException("Unknown virtualisation: " + virtualisation);
    }

    public static EC2InstanceType from(InstanceType instanceType) {
        Preconditions.checkNotNull((Object)instanceType);
        for (EC2InstanceType ec2InstanceType : EC2InstanceType.values()) {
            if (ec2InstanceType.getAwsInstanceType() != instanceType) continue;
            return ec2InstanceType;
        }
        throw new IllegalArgumentException("Unknown instance type: " + instanceType);
    }

    public String toString() {
        return this.name;
    }

    static {
        DEFAULT = M1_SMALL;
        oldGeneration = ImmutableSet.of((Object)"T1", (Object)"M1", (Object)"C1", (Object)"CC2", (Object)"M2", (Object)"CR1", (Object[])new String[]{"CG1", "HS1", "HI1"});
        currentGeneration = ImmutableSet.of((Object)"T2", (Object)"M4", (Object)"M3", (Object)"C4", (Object)"C3", (Object)"F1", (Object[])new String[]{"R3", "R4", "G2", "G3", "I2", "I3", "D2", "X1", "P2"});
        currentGenerationWithPv = ImmutableSet.of((Object)"C3", (Object)"M3");
        oldGenerationWithPv = ImmutableSet.of((Object)"C1", (Object)"HI1", (Object)"HS1", (Object)"M1", (Object)"M2", (Object)"T1", (Object[])new String[0]);
        oldGenerationWithHvm = ImmutableSet.of((Object)"CC2", (Object)"CR1", (Object)"HI1", (Object)"HS1", (Object)"CG1");
    }
}

