/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.model.AvailabilityZoneId;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AvailabilityZoneChooser {
    private static final Random RANDOM = new Random();
    private final LoadingCache<EC2InstanceType, Map<AvailabilityZoneId, DateTime>> azCapacityErrors = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<EC2InstanceType, Map<AvailabilityZoneId, DateTime>>(){

        public Map<AvailabilityZoneId, DateTime> load(@NotNull EC2InstanceType key) throws Exception {
            return new HashMap<AvailabilityZoneId, DateTime>();
        }
    });

    @NotNull
    public AvailabilityZoneId choose(@NotNull Iterable<AvailabilityZoneId> availabilityZones, @NotNull EC2InstanceType instanceType) {
        Preconditions.checkArgument((!Iterables.isEmpty(availabilityZones) ? 1 : 0) != 0, (Object)"No availablility zones to choose from");
        Map azsWithErrors = (Map)this.azCapacityErrors.getUnchecked((Object)instanceType);
        HashSet goodAvailabilityZones = Sets.newHashSet(availabilityZones);
        ArrayList<AvailabilityZoneId> worseAvailabilityZones = new ArrayList<AvailabilityZoneId>();
        DateTime oneHourAgo = new DateTime().minusHours(1);
        for (AvailabilityZoneId availabilityZone : availabilityZones) {
            DateTime errorTimestamp = (DateTime)azsWithErrors.get(availabilityZone);
            if (errorTimestamp == null || !errorTimestamp.isAfter((ReadableInstant)oneHourAgo)) continue;
            goodAvailabilityZones.remove(availabilityZone);
            worseAvailabilityZones.add(availabilityZone);
        }
        if (!goodAvailabilityZones.isEmpty()) {
            return this.pickRandomElement(goodAvailabilityZones);
        }
        return this.pickOldestElement(worseAvailabilityZones, azsWithErrors);
    }

    private AvailabilityZoneId pickRandomElement(Collection<AvailabilityZoneId> collection) {
        return (AvailabilityZoneId)Iterables.get(collection, (int)RANDOM.nextInt(collection.size()));
    }

    private AvailabilityZoneId pickOldestElement(Iterable<AvailabilityZoneId> interestingZones, Map<AvailabilityZoneId, DateTime> azsWithErrors) {
        DateTime oldestErrorTimestamp = null;
        AvailabilityZoneId oldestFullAvailabilityZone = null;
        for (AvailabilityZoneId availabilityZone : interestingZones) {
            DateTime errorTimestamp = azsWithErrors.get(availabilityZone);
            if (errorTimestamp == null || oldestErrorTimestamp != null && !errorTimestamp.isBefore((ReadableInstant)oldestErrorTimestamp)) continue;
            oldestErrorTimestamp = errorTimestamp;
            oldestFullAvailabilityZone = availabilityZone;
        }
        assert (oldestFullAvailabilityZone != null);
        return oldestFullAvailabilityZone;
    }

    public void blacklist(@NotNull AvailabilityZoneId availabilityZone, @NotNull EC2InstanceType instanceType) {
        Map availabilityZones = (Map)this.azCapacityErrors.getUnchecked((Object)instanceType);
        availabilityZones.put(availabilityZone, new DateTime());
    }
}

