/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSAccountImpl;
import com.atlassian.aws.AWSManager;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import java.util.concurrent.ScheduledExecutorService;

public class AWSManagerImpl
implements AWSManager {
    private final Ec2ClientFactory ec2ClientFactory;
    private final ScheduledExecutorService scheduledExecutorService;

    public AWSManagerImpl(Ec2ClientFactory ec2ClientFactory, ScheduledExecutorService scheduledExecutorService) {
        this.ec2ClientFactory = ec2ClientFactory;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public AWSAccount getAWSAccount(AwsSupportConstants.Region region, String awsAccessId, String awsSecretKey) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(awsAccessId, awsSecretKey);
        return this.getAWSAccount(region, (AWSCredentials)awsCredentials);
    }

    public AWSAccount getAWSAccount(AwsSupportConstants.Region region, AWSCredentials credentials) {
        return new AWSAccountImpl(this.ec2ClientFactory, this.scheduledExecutorService, credentials, region);
    }
}

