/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.AmazonEC2AsyncClient;
import com.amazonaws.services.ec2.model.AccountAttribute;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.CreateVolumeResult;
import com.amazonaws.services.ec2.model.DeleteVolumeRequest;
import com.amazonaws.services.ec2.model.DescribeAccountAttributesResult;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.CallTimingProxy;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.ec2.AmazonEc2Utils;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.Protocol;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.RemoteEC2InstanceImpl;
import com.atlassian.aws.ec2.SpotPrices;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.caches.ImageCache;
import com.atlassian.aws.ec2.caches.InstanceCache;
import com.atlassian.aws.ec2.caches.InstancePasswordCache;
import com.atlassian.aws.ec2.caches.SpotRequestCache;
import com.atlassian.aws.ec2.caches.SubnetCache;
import com.atlassian.aws.ec2.caches.VolumeCache;
import com.atlassian.aws.ec2.caches.VpcCache;
import com.atlassian.aws.ec2.model.InstanceId;
import com.atlassian.aws.ec2.model.VpcId;
import com.atlassian.aws.utils.Eithers;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AWSAccountImpl
implements AWSAccount {
    private static final Logger log = Logger.getLogger(AWSAccountImpl.class);
    private static final int DEFAULT_SUPERVISION_INTERVAL_SECONDS = 20;
    private final AwsSupportConstants.Region region;
    private int supervisionIntervalSeconds = 20;
    private static final int MAX_SUCCESSIVE_SUPERVISION_FAILURES = 10;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AmazonEC2Async asyncEc2Client;
    private final AmazonEC2AsyncClient deprecatedEc2Client;
    private final SpotRequestCache spotRequestCache;
    private final InstanceCache instanceCache;
    private final VpcCache vpcCache;
    private final VolumeCache volumeCache;
    private final SubnetCache subnetCache;
    private final InstancePasswordCache instancePasswordCache;
    private final ImageCache imageCache;
    final Supplier<Pair<AWSException, Map<String, AvailabilityZone>>> availabilityZones = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Pair<AWSException, Map<String, AvailabilityZone>>>(){

        public Pair<AWSException, Map<String, AvailabilityZone>> get() {
            List availabilityZones;
            try {
                availabilityZones = AWSAccountImpl.this.asyncEc2Client.describeAvailabilityZones().getAvailabilityZones();
            }
            catch (AmazonClientException exception) {
                return Eithers.left(new AWSException("Failed to query EC2 for availability zones descriptions.", exception));
            }
            Map<String, AvailabilityZone> availabilityZonesMap = availabilityZones.stream().collect(Collectors.toMap(AvailabilityZone::getZoneName, t -> t));
            return Eithers.right(availabilityZonesMap);
        }
    }, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    private final Supplier<Map<String, AccountAttribute>> accountAttributes = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Map<String, AccountAttribute>>(){

        public Map<String, AccountAttribute> get() {
            DescribeAccountAttributesResult describeAccountAttributesResult = AWSAccountImpl.this.asyncEc2Client.describeAccountAttributes();
            List accountAttributes = describeAccountAttributesResult.getAccountAttributes();
            return accountAttributes.stream().collect(Collectors.toMap(AccountAttribute::getAttributeName, t -> t));
        }
    }, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    private final Supplier<SpotPrices> spotPrices = Suppliers.memoizeWithExpiration((Supplier)new Supplier<SpotPrices>(){

        public SpotPrices get() {
            DescribeSpotPriceHistoryRequest request = new DescribeSpotPriceHistoryRequest().withStartTime(new Date());
            List spotPrices = AWSAccountImpl.this.asyncEc2Client.describeSpotPriceHistory(request).getSpotPriceHistory();
            return new SpotPrices(spotPrices);
        }
    }, (long)1L, (TimeUnit)TimeUnit.MINUTES);

    AWSAccountImpl(Ec2ClientFactory ec2ClientFactory, ScheduledExecutorService scheduledExecutorService, AWSCredentials awsCredentials, AwsSupportConstants.Region region) {
        if (StringUtils.isBlank((CharSequence)awsCredentials.getAWSAccessKeyId()) || StringUtils.isBlank((CharSequence)awsCredentials.getAWSSecretKey())) {
            throw new IllegalArgumentException("awsAccessId and awsSecretKey must be specified.");
        }
        this.scheduledExecutorService = scheduledExecutorService;
        this.deprecatedEc2Client = ec2ClientFactory.newAwsAsyncClient(region, awsCredentials, scheduledExecutorService);
        this.asyncEc2Client = CallTimingProxy.wrap(this.deprecatedEc2Client, AmazonEC2Async.class);
        this.spotRequestCache = new SpotRequestCache(this.asyncEc2Client);
        this.instanceCache = new InstanceCache(this.asyncEc2Client);
        this.vpcCache = new VpcCache(this.asyncEc2Client);
        this.volumeCache = new VolumeCache(this.asyncEc2Client);
        this.instancePasswordCache = new InstancePasswordCache(this.asyncEc2Client);
        this.subnetCache = new SubnetCache(this.asyncEc2Client);
        this.imageCache = new ImageCache(this.asyncEc2Client);
        this.region = region;
    }

    @Override
    public String getAccountValidationError() throws AWSException {
        try {
            this.asyncEc2Client.describeAvailabilityZones();
        }
        catch (AmazonServiceException e) {
            if (AmazonServiceErrorCode.UNAUTHORISED_OPERATION.is(e)) {
                return null;
            }
            log.info((Object)"Unable to validate account: ", (Throwable)e);
            return e.getMessage();
        }
        catch (AmazonClientException e) {
            throw new AWSException("Failed to determine the validity of AWS credentials.", e);
        }
        return null;
    }

    @Override
    @Nullable
    public String getConsoleOutput(String instanceId) {
        try {
            GetConsoleOutputResult consoleOutput = this.asyncEc2Client.getConsoleOutput(new GetConsoleOutputRequest(instanceId));
            String base64Log = StringUtils.trimToEmpty((String)consoleOutput.getOutput());
            return new String(Base64.getMimeDecoder().decode(base64Log), StandardCharsets.UTF_8);
        }
        catch (AmazonClientException e) {
            log.warn((Object)("Unable to get console output for " + instanceId + ". Null being returned."), (Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public Collection<Instance> getAllInstances() throws AWSException {
        try {
            Collection describeInstancesResult = this.instanceCache.describe(new String[0]);
            return describeInstancesResult.stream().filter(instance -> !AwsSupportConstants.InstanceStateName.Terminated.is(instance.getState())).collect(Collectors.toList());
        }
        catch (AmazonClientException e) {
            throw new AWSException("Unable to retrieve the list of running elastic instances.", e);
        }
    }

    @Override
    @NotNull
    public Collection<SpotInstanceRequest> describePendingSpotInstanceRequests(String ... spotInstanceRequestIds) {
        Collection spotInstanceRequests = this.spotRequestCache.describe(spotInstanceRequestIds);
        return spotInstanceRequests.stream().filter(r -> AwsSupportConstants.SpotInstanceRequestState.OPEN.is(r.getState())).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public RemoteEC2Instance newEC2Instance(@NotNull InstanceLaunchConfiguration instanceLaunchConfiguration, EC2InstanceListener listener) {
        RemoteEC2InstanceImpl ec2Instance = new RemoteEC2InstanceImpl(instanceLaunchConfiguration, this.supervisionIntervalSeconds, 10, listener, this, this.scheduledExecutorService);
        return ec2Instance;
    }

    @Override
    @NotNull
    public List<Address> describeAddresses(String ... domains) {
        DescribeAddressesRequest describeAddressesRequest = new DescribeAddressesRequest();
        if (domains.length != 0) {
            Filter filter = AWSAccountImpl.newDomainFilter(domains);
            describeAddressesRequest.withFilters(new Filter[]{filter});
        }
        DescribeAddressesResult describeAddressesResult = this.asyncEc2Client.describeAddresses(describeAddressesRequest);
        return describeAddressesResult.getAddresses();
    }

    @NotNull
    private static Filter newDomainFilter(String[] domains) {
        return new Filter("domain", Arrays.asList(domains));
    }

    @Override
    @NotNull
    public Map<String, AccountAttribute> getAccountAttributes() {
        return (Map)this.accountAttributes.get();
    }

    @Override
    public SubnetCache getSubnetCache() {
        return this.subnetCache;
    }

    @Override
    @NotNull
    public Iterable<SecurityGroup> describeSecurityGroups() throws AWSException {
        DescribeSecurityGroupsResult groupDescriptions;
        try {
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest = new DescribeSecurityGroupsRequest();
            groupDescriptions = this.asyncEc2Client.describeSecurityGroups(describeSecurityGroupsRequest);
        }
        catch (AmazonClientException exception) {
            throw new AWSException("Failed to query EC2 for group descriptions.", exception);
        }
        return groupDescriptions.getSecurityGroups();
    }

    @Override
    @NotNull
    public SecurityGroup newSecurityGroup(@NotNull String name, @NotNull String description, @Nullable VpcId vpcId) throws AWSException {
        String vpcIdStr = null;
        if (vpcId != null && !vpcId.isUndefined()) {
            vpcIdStr = vpcId.getId();
        }
        try {
            CreateSecurityGroupRequest createSecurityGroupRequest = new CreateSecurityGroupRequest().withGroupName(name).withDescription(description).withVpcId(vpcIdStr);
            CreateSecurityGroupResult createSecurityGroupResult = this.asyncEc2Client.createSecurityGroup(createSecurityGroupRequest);
            return new SecurityGroup().withGroupId(createSecurityGroupResult.getGroupId()).withGroupName(name).withDescription(description).withVpcId(vpcIdStr);
        }
        catch (AmazonClientException exception) {
            throw new AWSException("Failed to create EC2 security group.", exception);
        }
    }

    @Override
    public void ensureInboundTrafficIsAllowed(@NotNull SecurityGroup group, @NotNull Protocol protocol, @NotNull String cidrIpRange, int port) {
        AmazonEc2Utils.ensureInboundTrafficIsAllowed((AmazonEC2)this.asyncEc2Client, group, protocol, cidrIpRange, port);
    }

    @Override
    @NotNull
    public Map<String, KeyPairInfo> describeEc2KeyPairs(String ... keyNames) {
        DescribeKeyPairsRequest describeKeyPairsRequest = new DescribeKeyPairsRequest();
        if (keyNames.length != 0) {
            describeKeyPairsRequest.withKeyNames(keyNames);
        }
        DescribeKeyPairsResult keyPairInfos = this.asyncEc2Client.describeKeyPairs(describeKeyPairsRequest);
        return keyPairInfos.getKeyPairs().stream().collect(Collectors.toMap(KeyPairInfo::getKeyName, t -> t));
    }

    @Override
    @NotNull
    public KeyPair newEC2KeyPair(String name) throws AWSException {
        CreateKeyPairResult keyPairInfo;
        try {
            keyPairInfo = this.asyncEc2Client.createKeyPair(new CreateKeyPairRequest(name));
        }
        catch (AmazonClientException exception) {
            throw new AWSException("Failed to create EC2 key pair.", exception);
        }
        return keyPairInfo.getKeyPair();
    }

    @Override
    @NotNull
    public Map<String, AvailabilityZone> getAvailabilityZones() throws AWSException {
        return (Map)Eithers.getOrThrow((Pair)this.availabilityZones.get());
    }

    @Override
    @NotNull
    public Map<Vpc, Collection<Subnet>> describeVpcs() throws AWSException {
        List subnets;
        try {
            subnets = this.asyncEc2Client.describeSubnets().getSubnets();
        }
        catch (AmazonClientException e2) {
            throw new AWSException("Failed to fetch the VPCs list", e2);
        }
        HashMap<Vpc, Collection<Subnet>> vpcsAndSubnets = new HashMap<Vpc, Collection<Subnet>>();
        for (Subnet subnet : subnets) {
            Vpc vpc = (Vpc)Iterables.getOnlyElement(this.vpcCache.describe(subnet.getVpcId()));
            vpcsAndSubnets.computeIfAbsent(vpc, e -> new ArrayList()).add(subnet);
        }
        return vpcsAndSubnets;
    }

    @Override
    public void shutdownInstance(String instanceId) throws AWSException {
        try {
            this.asyncEc2Client.terminateInstances(new TerminateInstancesRequest(Collections.singletonList(instanceId)));
        }
        catch (AmazonClientException e) {
            throw new AWSException("Error terminating elastic instance with id '" + instanceId + "'", e);
        }
    }

    @Override
    public void cancelSpotInstanceRequests(String ... spotInstanceRequestIds) {
        CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest = new CancelSpotInstanceRequestsRequest().withSpotInstanceRequestIds(spotInstanceRequestIds);
        this.asyncEc2Client.cancelSpotInstanceRequests(cancelSpotInstanceRequestsRequest);
    }

    @Override
    public void deleteVolume(String volumeId) throws AWSException {
        try {
            this.asyncEc2Client.deleteVolume(new DeleteVolumeRequest(volumeId));
        }
        catch (AmazonClientException e) {
            throw new AWSException("Error deleting ebs volume with id '" + volumeId + "'", e);
        }
    }

    @Override
    @NotNull
    public SpotPrices getSpotPrices() {
        return (SpotPrices)this.spotPrices.get();
    }

    @Override
    @NotNull
    public AmazonEC2AsyncClient getAwsClient() {
        return this.deprecatedEc2Client;
    }

    @Override
    public AmazonEC2Async getAmazonEc2() {
        return this.asyncEc2Client;
    }

    @Override
    public Collection<Instance> describeInstances(String ... instanceIds) {
        return this.instanceCache.describe(instanceIds);
    }

    @Override
    @NotNull
    public Collection<Subnet> describeSubnets(String ... subnetIds) {
        return this.subnetCache.describe(subnetIds);
    }

    @Override
    public String getPassword(@NotNull String privateKeyFile, @NotNull String instanceId) {
        return this.getPassword(new File(privateKeyFile), InstanceId.from(instanceId));
    }

    @Override
    public String getPassword(@NotNull File privateKeyFile, @NotNull InstanceId instanceId) {
        return this.instancePasswordCache.getPassword(privateKeyFile, instanceId);
    }

    @Override
    public Collection<SpotInstanceRequest> describeSpotInstanceRequests(String ... spotInstanceRequestIds) {
        return this.spotRequestCache.describe(spotInstanceRequestIds);
    }

    @Override
    public Image describeImage(@NotNull String imageId) {
        return (Image)Iterables.getOnlyElement(this.describeImages(imageId), null);
    }

    @Override
    public List<Image> describeImages(String ... imageIds) {
        return this.imageCache.describeImages(imageIds);
    }

    @Override
    public void createTag(@NotNull String resourceId, @NotNull String key, @NotNull String value) {
        CreateTagsRequest createTagsRequest = new CreateTagsRequest().withResources(new String[]{resourceId}).withTags(new Tag[]{new Tag(key, value)});
        this.asyncEc2Client.createTagsAsync(createTagsRequest);
    }

    @Override
    @NotNull
    public Collection<Volume> describeVolumes() throws AWSException {
        try {
            return this.volumeCache.describe(new String[0]);
        }
        catch (Exception e) {
            throw new AWSException("Failed to retrieve information about EBS volumes.", e);
        }
    }

    @Override
    public String createVolume(@NotNull String ebsSnapshotId, @NotNull String availabilityZone) {
        CreateVolumeRequest createVolumeRequest = new CreateVolumeRequest().withSnapshotId(ebsSnapshotId).withAvailabilityZone(availabilityZone);
        CreateVolumeResult createVolumeResult = this.asyncEc2Client.createVolume(createVolumeRequest);
        return createVolumeResult.getVolume().getVolumeId();
    }

    @Override
    public void attachVolume(@NotNull String volumeId, @NotNull String instanceId, @NotNull String deviceName, boolean deleteOnTermination) {
        AttachVolumeRequest attachVolumeRequest = new AttachVolumeRequest().withVolumeId(volumeId).withInstanceId(instanceId).withDevice(deviceName);
        this.asyncEc2Client.attachVolume(attachVolumeRequest);
        if (deleteOnTermination) {
            this.enableDeleteOnTermination(instanceId, volumeId, deviceName);
        }
    }

    private void enableDeleteOnTermination(@NotNull String instanceId, @NotNull String volumeId, @NotNull String attachedDeviceName) {
        EbsInstanceBlockDeviceSpecification ebsInstanceBlockDeviceSpecification = new EbsInstanceBlockDeviceSpecification().withVolumeId(volumeId).withDeleteOnTermination(Boolean.valueOf(true));
        InstanceBlockDeviceMappingSpecification instanceBlockDeviceMappingSpecification = new InstanceBlockDeviceMappingSpecification().withDeviceName(attachedDeviceName).withEbs(ebsInstanceBlockDeviceSpecification);
        ModifyInstanceAttributeRequest modifyInstanceAttributeRequest = new ModifyInstanceAttributeRequest().withBlockDeviceMappings(new InstanceBlockDeviceMappingSpecification[]{instanceBlockDeviceMappingSpecification}).withInstanceId(instanceId);
        this.asyncEc2Client.modifyInstanceAttribute(modifyInstanceAttributeRequest);
    }

    @Override
    public void setMaximumEbsVolumeStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.volumeCache.setMaximumStatusAgeSeconds(maximumStatusAgeSeconds);
    }

    @Override
    public void setMaximumInstanceStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.supervisionIntervalSeconds = maximumStatusAgeSeconds;
        this.instanceCache.setMaximumStatusAgeSeconds(maximumStatusAgeSeconds);
    }

    @Override
    public void setMaximumSpotRequestStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.spotRequestCache.setMaximumStatusAgeSeconds(maximumStatusAgeSeconds);
    }

    @Override
    public AwsSupportConstants.Region getRegion() {
        return this.region;
    }
}

