/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.ec2.EC2Image;
import com.atlassian.aws.ec2.EC2ImageImpl;
import com.atlassian.aws.ec2.EC2Instance;
import com.atlassian.aws.ec2.LocalEC2InstanceImpl;
import com.atlassian.urlfetcher.URLFetcherUtils;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class EC2Utils {
    private static final String API_BASE_URL = "http://169.254.169.254/2008-02-01/";
    static final String USER_DATA_URL = "http://169.254.169.254/2008-02-01/user-data";
    static final String META_DATA_BASE_URL = "http://169.254.169.254/2008-02-01/meta-data/";
    private static final String AMI_ID_URL = "http://169.254.169.254/2008-02-01/meta-data/ami-id";

    public static EC2Instance getLocalEC2Instance() throws IOException {
        return new LocalEC2InstanceImpl();
    }

    public static void setUserData(LaunchConfiguration launchConfiguration, Object userData) throws IOException {
        byte[] binaryUserData;
        if (userData == null) {
            binaryUserData = null;
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(userData);
            objectOutputStream.close();
            binaryUserData = byteArrayOutputStream.toByteArray();
        }
        launchConfiguration.setUserData(binaryUserData);
    }

    public static Object getUserData() throws IOException, ClassNotFoundException {
        return URLFetcherUtils.getURLFetcher().fetchSerializedObject(USER_DATA_URL);
    }

    public static EC2Image getCurrentImage() throws IOException {
        String amiId = URLFetcherUtils.getURLFetcher().fetchString(AMI_ID_URL);
        if (amiId == null) {
            throw new IOException("Could not obtain AMI ID.");
        }
        return new EC2ImageImpl(amiId);
    }
}

