/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.xerox.amazonws.ec2.InstanceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EC2InstanceType {
    M1_SMALL("Small", "1 EC2 Compute Unit (1 virtual core with 1 EC2 Compute Unit)\n1.7 GB RAM\n160 GB instance storage (150 GB plus 10 GB root partition)\n32-bit architecture\nModerate I/O performance", InstanceType.DEFAULT),
    M1_LARGE("Large", "4 EC2 Compute Units (2 virtual cores with 2 EC2 Compute Units each)\n7.5 GB RAM\n850 GB instance storage (2 x 420 GB plus 10 GB root partition)\n64-bit architecture\nHigh I/O performance", InstanceType.LARGE),
    M1_XLARGE("Extra Large", "8 EC2 Compute Units (4 virtual cores with 2 EC2 Compute Units each)\n15 GB RAM\n1690 GB instance storage (4 x 420 GB plus 10 GB root partition)\n64-bit architecture\nHigh I/O performance", InstanceType.XLARGE),
    C1_MEDIUM("High-CPU Medium", "5 EC2 Compute Units (2 virtual cores with 2.5 EC2 Compute Units each)\n1.7 GB RAM\n350 GB instance storage (340 GB plus 10 GB root partition)\n32-bit architecture\nModerate I/O performance", InstanceType.MEDIUM_HCPU),
    C1_XLARGE("High-CPU Extra Large", "20 EC2 Compute Units (8 virtual cores with 2.5 EC2 Compute Units each)\n7 GB RAM\n1,690 GB instance storage (4 x 420 GB plus 10 GB root partition)\n64-bit architecture\nHigh I/O performance", InstanceType.XLARGE_HCPU);

    public static final EC2InstanceType DEFAULT;
    private final String name;
    private final String description;
    private final InstanceType apiParameterValue;

    private EC2InstanceType(String name, String description, InstanceType apiParameterValue) {
        this.name = name;
        this.description = description;
        this.apiParameterValue = apiParameterValue;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public InstanceType getApiParameterValue() {
        return this.apiParameterValue;
    }

    public String toString() {
        return this.name;
    }

    static {
        DEFAULT = M1_SMALL;
    }
}

