/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.atlassian.aws.Jec2Factory;
import com.xerox.amazonws.ec2.Jec2;

public class EucalyptusAwareJec2Factory
implements Jec2Factory {
    private final String ec2Server;
    private final int port;

    public EucalyptusAwareJec2Factory() {
        this(null, 0);
    }

    public EucalyptusAwareJec2Factory(String ec2Server, int port) {
        if (ec2Server != null && port <= 0) {
            throw new IllegalArgumentException("You must specify a valid port if an alternative ec2Server is also specified");
        }
        this.ec2Server = ec2Server;
        this.port = port;
    }

    public Jec2 newJec2(String awsAccessId, String awsSecretKey) {
        Jec2 jec2 = this.ec2Server == null ? new Jec2(awsAccessId, awsSecretKey) : new Jec2(awsAccessId, awsSecretKey, true, this.ec2Server, this.port);
        jec2.useSystemProxy();
        return jec2;
    }
}

