/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EBSVolume;
import com.atlassian.aws.ec2.EBSVolumeImpl;
import com.atlassian.aws.ec2.EC2Image;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.EC2InstanceState;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.xerox.amazonws.ec2.AttachmentInfo;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.TerminatingInstanceDescription;
import com.xerox.amazonws.ec2.VolumeInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteEC2InstanceImpl
implements RemoteEC2Instance {
    private static final Logger log = Logger.getLogger(RemoteEC2InstanceImpl.class);
    private static final int SHUTDOWN_TIMEOUT_IN_SECONDS = 300;
    private final AtomicInteger successiveSupervisionFailures = new AtomicInteger();
    private final Jec2 jec2;
    private final EC2Image image;
    private final String keyName;
    private final List<String> securityGroupIds;
    private final Object userData;
    private final EC2InstanceType instanceType;
    private final String requestedAvailabilityZone;
    private final int pollPeriodInSeconds;
    private final int maxSuccessiveSupervisionFailures;
    private final int startupTimeoutInSeconds;
    private final EC2InstanceListener listener;
    private final ScheduledExecutorService scheduledExecutorService;
    private final List<Throwable> backgroundThrowables;
    private final Runnable launcher = new CatchingRunnableDecorator("backgroundStart()", new Runnable(){

        public void run() {
            RemoteEC2InstanceImpl.this.backgroundStart();
        }
    });
    private final Runnable supervisor = new CatchingRunnableDecorator("backgroundSupervise()", new Runnable(){

        public void run() {
            RemoteEC2InstanceImpl.this.backgroundSupervise();
        }
    });
    private final Runnable terminator = new CatchingRunnableDecorator("backgroundTerminate()", new Runnable(){

        public void run() {
            RemoteEC2InstanceImpl.this.backgroundTerminate();
        }
    });
    private String id;
    private boolean started;
    private boolean terminating;
    private volatile ScheduledFuture<?> supervisorJob;
    private volatile EC2InstanceState state = EC2InstanceState.STARTING;
    private volatile long deadline;
    private volatile Calendar launchTime;
    private volatile String dnsName;
    private volatile String availabilityZone;

    private static <T> T getSingle(String noun, List<T> list) {
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        throw new IllegalStateException("Expected 1 " + noun + ", but " + size + " were returned.");
    }

    public RemoteEC2InstanceImpl(EC2Image image, String keyName, List<String> securityGroupIds, Object userData, EC2InstanceType instanceType, String requestedAvailabilityZone, int pollPeriodInSeconds, int maxSuccessiveSupervisionFailures, int startupTimeoutInSeconds, EC2InstanceListener listener, Jec2 jec2, ScheduledExecutorService scheduledExecutorService, List<Throwable> backgroundThrowables) {
        this.image = image;
        this.keyName = keyName;
        this.securityGroupIds = securityGroupIds;
        this.userData = userData;
        this.maxSuccessiveSupervisionFailures = maxSuccessiveSupervisionFailures;
        this.instanceType = instanceType == null ? EC2InstanceType.DEFAULT : instanceType;
        this.requestedAvailabilityZone = requestedAvailabilityZone;
        this.pollPeriodInSeconds = pollPeriodInSeconds;
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
        this.listener = listener;
        this.jec2 = jec2;
        this.scheduledExecutorService = scheduledExecutorService;
        this.backgroundThrowables = backgroundThrowables;
    }

    @Override
    public EC2InstanceType getInstanceType() {
        return this.instanceType;
    }

    @Override
    public Calendar getLaunchTime() {
        return this.launchTime;
    }

    @Override
    public String getDnsName() {
        return this.dnsName;
    }

    @Override
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("Already started.");
        }
        this.started = true;
        this.scheduledExecutorService.execute(this.launcher);
    }

    @Override
    public synchronized void terminate() {
        if (!this.started) {
            throw new IllegalStateException("Not started.");
        }
        if (!this.terminating) {
            this.terminating = true;
            this.scheduledExecutorService.execute(this.terminator);
        }
    }

    @Override
    public List<EBSVolume> getAttachedVolumes() throws AWSException, IOException {
        List volumeInfos;
        try {
            volumeInfos = this.jec2.describeVolumes(Collections.emptyList());
        }
        catch (EC2Exception exception) {
            throw new AWSException("Could not retrieve volume descriptions.", exception);
        }
        ArrayList<EBSVolume> ebsVolumes = new ArrayList<EBSVolume>();
        block2: for (VolumeInfo volumeInfo : volumeInfos) {
            for (AttachmentInfo attachmentInfo : volumeInfo.getAttachmentInfo()) {
                if (!attachmentInfo.getInstanceId().equals(this.getID())) continue;
                ebsVolumes.add(new EBSVolumeImpl(volumeInfo, this, this.jec2));
                continue block2;
            }
        }
        return ebsVolumes;
    }

    List<TerminatingInstanceDescription> terminateInstances(List<String> instanceIds) throws EC2Exception {
        List terminatingInstanceDescriptions = this.jec2.terminateInstances(instanceIds);
        for (TerminatingInstanceDescription terminatingInstance : terminatingInstanceDescriptions) {
            log.info((Object)("EC2 instance " + terminatingInstance.getInstanceId() + " transitioned from " + terminatingInstance.getPreviousState() + " (" + terminatingInstance.getPreviousStateCode() + ") to " + terminatingInstance.getShutdownState() + " (" + terminatingInstance.getShutdownStateCode() + ")"));
        }
        return terminatingInstanceDescriptions;
    }

    ReservationDescription.Instance describeInstance() throws EC2Exception {
        ReservationDescription.Instance instance = (ReservationDescription.Instance)RemoteEC2InstanceImpl.getSingle("EC2 instance", ((ReservationDescription)RemoteEC2InstanceImpl.getSingle("EC2 reservation", this.jec2.describeInstances(Collections.singletonList(this.getID())))).getInstances());
        this.launchTime = instance.getLaunchTime();
        return instance;
    }

    Object getUserData() {
        return this.userData;
    }

    EC2Image getImage() {
        return this.image;
    }

    @Override
    public synchronized String getID() {
        return this.id;
    }

    void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    protected void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    void setShutdownDeadline() {
        this.setDeadline(300);
    }

    boolean isDeadlinePassed() {
        return System.currentTimeMillis() > this.deadline;
    }

    AWSException unexpectedStateException(ReservationDescription.Instance instance) {
        return new AWSException("EC2 instance " + this.id + " in unexpected state " + instance.getState() + " (" + instance.getStateCode() + ") for reason \"" + instance.getReason() + "\"");
    }

    void shuttingDown() {
        String details = "Bamboo has detected that EC2 instance " + this.getID() + " is shutting down.";
        log.info((Object)details);
        this.setShutdownDeadline();
        this.setState(EC2InstanceState.SHUTTING_DOWN, details, null);
    }

    void terminated() {
        String details = "EC2 instance " + this.getID() + " has terminated.";
        log.info((Object)details);
        this.setState(EC2InstanceState.TERMINATED, details, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void backgroundStart() {
        log.trace((Object)"Entered backgroundStart()");
        try {
            List instances;
            try {
                String imageId = this.image.getId();
                LaunchConfiguration launchConfiguration = new LaunchConfiguration(imageId);
                launchConfiguration.setKeyName(this.keyName);
                launchConfiguration.setSecurityGroup(this.securityGroupIds);
                launchConfiguration.setInstanceType(this.instanceType.getApiParameterValue());
                launchConfiguration.setAvailabilityZone(this.requestedAvailabilityZone);
                EC2Utils.setUserData(launchConfiguration, this.userData);
                log.info((Object)("Ordering EC2 instance of image " + imageId));
                instances = this.jec2.runInstances(launchConfiguration).getInstances();
            }
            catch (Throwable throwable) {
                String details = "EC2 instance order failed.";
                log.error((Object)"EC2 instance order failed.", throwable);
                this.setState(EC2InstanceState.FAILED_TO_START, "EC2 instance order failed.", throwable);
                log.trace((Object)"Finished backgroundStart()");
                return;
            }
            try {
                ReservationDescription.Instance instance = (ReservationDescription.Instance)RemoteEC2InstanceImpl.getSingle("EC2 impl", instances);
                String id = instance.getInstanceId();
                String details = "Ordered EC2 instance " + id;
                log.info((Object)details);
                this.id = id;
                this.notifyAll();
                this.setDeadline(this.startupTimeoutInSeconds);
                this.setState(EC2InstanceState.PENDING, details, null);
                this.setAvailabilityZone(instance.getAvailabilityZone());
                this.supervisorJob = this.scheduledExecutorService.scheduleWithFixedDelay(this.supervisor, 0L, this.pollPeriodInSeconds, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                StringBuilder details = new StringBuilder("Failed to process response to order for EC2 instance.");
                try {
                    log.error((Object)details, throwable);
                    if (!instances.isEmpty()) {
                        StringBuilder message = new StringBuilder("Terminating instances ");
                        ArrayList<String> instanceIds = new ArrayList<String>();
                        for (ReservationDescription.Instance instance : instances) {
                            String instanceId = instance.getInstanceId();
                            message.append(" ");
                            message.append(instanceId);
                            instanceIds.add(instanceId);
                        }
                        log.info((Object)message);
                        details.append(SystemUtils.LINE_SEPARATOR);
                        details.append((CharSequence)message);
                        this.terminateInstances(instanceIds);
                    }
                }
                catch (Throwable throwable2) {
                    String message = "Failed to terminate instances.";
                    log.error((Object)"Failed to terminate instances.", throwable);
                    details.append(SystemUtils.LINE_SEPARATOR);
                    details.append("Failed to terminate instances.");
                }
                this.setState(EC2InstanceState.FAILED_TO_START, details.toString(), throwable);
            }
        }
        finally {
            log.trace((Object)"Finished backgroundStart()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void backgroundSupervise() {
        block7: {
            log.trace((Object)"Entered backgroundSupervise()");
            try {
                if (this.state.isFinal()) {
                    throw new IllegalStateException((Object)((Object)this.state) + " is a final state.");
                }
                try {
                    this.state.supervise(this);
                    this.successiveSupervisionFailures.set(0);
                }
                catch (Throwable throwable) {
                    if (this.successiveSupervisionFailures.incrementAndGet() > this.maxSuccessiveSupervisionFailures) {
                        log.error((Object)("Request for current status of EC2 instance" + this.getID() + " failed after " + this.maxSuccessiveSupervisionFailures + " attempts.  No further attempts will be made."), throwable);
                        this.state.supervisionFailure(this, throwable);
                        break block7;
                    }
                    log.warn((Object)("Request for current status of EC2 instance " + this.getID() + " failed.  Will retry later."), throwable);
                }
            }
            finally {
                log.trace((Object)"Finished backgroundSupervise()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void backgroundTerminate() {
        block9: {
            log.trace((Object)"Entered backgroundTerminate()");
            try {
                while (this.id == null && !this.state.isFinal()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException exception) {}
                }
                if (this.id == null) break block9;
                List<String> instanceIds = Collections.singletonList(this.id);
                while (true) {
                    try {
                        this.setState(EC2InstanceState.SHUTTING_DOWN, "Bamboo is requesting that EC2 instance " + this.id + " be shut down.", null);
                        this.terminateInstances(instanceIds);
                    }
                    catch (EC2Exception exception) {
                        log.warn((Object)("Failed to order termination of EC2 instance " + this.id + ".  Retrying."), (Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
            finally {
                log.trace((Object)"Finished backgroundTerminate()");
            }
        }
    }

    void setState(final EC2InstanceState state, final String details, final Throwable throwable) {
        if (!state.equals((Object)this.state)) {
            final EC2InstanceState previousState = this.state;
            this.state = state;
            if (state.isFinal() && this.supervisorJob != null) {
                log.debug((Object)"Cancelling supervisor");
                this.supervisorJob.cancel(false);
            }
            new CatchingRunnableDecorator("Listener " + this.listener, new Runnable(){

                public void run() {
                    RemoteEC2InstanceImpl.this.listener.ec2InstanceStateChanged(RemoteEC2InstanceImpl.this, previousState, state, details, throwable);
                }
            }).run();
        }
    }

    private void setDeadline(int timeoutInSeconds) {
        this.deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutInSeconds);
    }

    private class CatchingRunnableDecorator
    implements Runnable {
        private final String description;
        private final Runnable runnable;

        public CatchingRunnableDecorator(String description, Runnable runnable) {
            this.description = description;
            this.runnable = runnable;
        }

        public void run() {
            block2: {
                try {
                    log.trace((Object)("Entering " + this.description));
                    this.runnable.run();
                }
                catch (Throwable throwable) {
                    log.error((Object)("Exception during " + this.description), throwable);
                    if (RemoteEC2InstanceImpl.this.backgroundThrowables == null) break block2;
                    RemoteEC2InstanceImpl.this.backgroundThrowables.add(throwable);
                }
            }
        }
    }
}

