/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2SecurityGroup;
import com.atlassian.aws.ec2.Protocol;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.Jec2;

public class EC2SecurityGroupImpl
implements EC2SecurityGroup {
    private final Jec2 jec2;
    private final GroupDescription groupDescription;

    public EC2SecurityGroupImpl(Jec2 jec2, GroupDescription groupDescription) {
        this.jec2 = jec2;
        this.groupDescription = groupDescription;
    }

    public void authoriseIngress(Protocol protocol, String fromAddresses, int fromPort, int toPort) throws AWSException {
        String groupName = this.groupDescription.getName();
        String protocolValue = protocol.getValue();
        try {
            this.jec2.authorizeSecurityGroupIngress(groupName, protocolValue, fromPort, toPort, fromAddresses);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to authorise ingress.", exception);
        }
    }
}

