/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.RemoteEC2InstanceImpl;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EC2InstanceState {
    STARTING(false),
    PENDING(false){

        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            ReservationDescription.Instance instance = impl.describeInstance();
            if (instance.isRunning()) {
                String dnsName = instance.getDnsName();
                if (!StringUtils.isEmpty((String)dnsName)) {
                    log.info((Object)("EC2 instance " + impl.getID() + " running at " + dnsName));
                    impl.setDnsName(dnsName);
                    impl.setState(RUNNING, null, null);
                    return;
                }
            } else {
                if (instance.isShuttingDown()) {
                    impl.shuttingDown();
                    return;
                }
                if (instance.isTerminated()) {
                    impl.terminated();
                    return;
                }
                if (!instance.isPending()) {
                    throw impl.unexpectedStateException(instance);
                }
            }
            if (impl.isDeadlinePassed()) {
                throw new AWSException("Deadline passed waiting for EC2 instance " + impl.getID() + " to start.");
            }
        }

        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String details = "EC2 instance " + impl.getID() + " failed to start.  Attempting to terminate.";
            log.error((Object)details, throwable);
            try {
                impl.terminateInstances(Collections.singletonList(impl.getID()));
            }
            catch (Throwable throwable2) {
                log.error((Object)("Failed to terminate EC2 instance " + impl.getID()), throwable2);
            }
            impl.setState(FAILED_TO_START, details, throwable);
        }
    }
    ,
    FAILED_TO_START(true),
    RUNNING(false){

        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            ReservationDescription.Instance instance = impl.describeInstance();
            if (instance.isRunning()) {
                return;
            }
            if (instance.isShuttingDown()) {
                impl.shuttingDown();
                return;
            }
            if (instance.isTerminated()) {
                impl.terminated();
                return;
            }
            throw impl.unexpectedStateException(instance);
        }

        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String details = "Failure in EC2 instance " + impl.getID() + ".  Attempting to terminate.";
            log.error((Object)details, throwable);
            try {
                impl.terminateInstances(Collections.singletonList(impl.getID()));
            }
            catch (Throwable throwable2) {
                log.error((Object)("Failed to terminate EC2 instance " + impl.getID()), throwable2);
            }
            impl.setState(UNKNOWN, details, throwable);
        }
    }
    ,
    SHUTTING_DOWN(false){

        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            ReservationDescription.Instance instance = impl.describeInstance();
            if (instance.isShuttingDown()) {
                return;
            }
            if (instance.isTerminated()) {
                impl.terminated();
                return;
            }
            throw impl.unexpectedStateException(instance);
        }

        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String details = "EC2 instance " + impl.getID() + " failed to shut down.";
            log.error((Object)details, throwable);
            impl.setState(UNKNOWN, details, throwable);
        }
    }
    ,
    TERMINATED(true),
    UNKNOWN(true);

    private static final Logger log;
    private final boolean isFinal;

    private EC2InstanceState(boolean isFinal) {
        this.isFinal = isFinal;
    }

    final boolean isFinal() {
        return this.isFinal;
    }

    void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
        throw new UnsupportedOperationException((Object)((Object)this) + " is not implemented.");
    }

    void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
        throw new UnsupportedOperationException((Object)((Object)this) + " is not implemented.");
    }

    static {
        log = Logger.getLogger(EC2InstanceState.class);
    }
}

