/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.Jec2Factory;
import com.atlassian.aws.ec2.EC2AvailabilityZone;
import com.atlassian.aws.ec2.EC2AvailabilityZoneImpl;
import com.atlassian.aws.ec2.EC2Image;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2KeyPairDescription;
import com.atlassian.aws.ec2.EC2KeyPairDescriptionImpl;
import com.atlassian.aws.ec2.EC2PrivateKey;
import com.atlassian.aws.ec2.EC2PrivateKeyImpl;
import com.atlassian.aws.ec2.EC2SecurityGroup;
import com.atlassian.aws.ec2.EC2SecurityGroupImpl;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.RemoteEC2InstanceImpl;
import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AWSAccountImpl
implements AWSAccount {
    private static final int POLLING_INTERVAL_IN_SECONDS = 10;
    private static final int MAX_SUCCESSIVE_SUPERVISION_FAILURES = 10;
    private static final Set<String> INVALID_CREDENTIALS_MESSAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Client error : The AWS Access Key Id you provided does not exist in our records.", "Client error : The request signature we calculated does not match the signature you provided. Check your AWS Secret Access Key and signing method. Consult the service documentation for details.")));
    private final ScheduledExecutorService scheduledExecutorService;
    private final Jec2 jec2;

    AWSAccountImpl(Jec2Factory jec2Factory, ScheduledExecutorService scheduledExecutorService, String awsAccessId, String awsSecretKey) {
        if (StringUtils.isBlank((String)awsAccessId) || StringUtils.isBlank((String)awsSecretKey)) {
            throw new IllegalArgumentException("awsAccessId and awsSecretKey must be specified.");
        }
        this.scheduledExecutorService = scheduledExecutorService;
        this.jec2 = jec2Factory.newJec2(awsAccessId, awsSecretKey);
    }

    @Override
    public boolean validate() throws AWSException {
        try {
            this.jec2.describeAvailabilityZones(null);
        }
        catch (EC2Exception exception) {
            if (INVALID_CREDENTIALS_MESSAGES.contains(exception.getMessage())) {
                return false;
            }
            throw new AWSException("Failed to determine validity of AWS credentials.", exception);
        }
        return true;
    }

    @Override
    @Deprecated
    public RemoteEC2Instance newEC2Instance(EC2Image image, String keyName, List<String> securityGroupIds, Object userData, EC2InstanceType instanceType, int timeoutSeconds, EC2InstanceListener listener) {
        return this.newEC2Instance(image, keyName, securityGroupIds, userData, instanceType, null, timeoutSeconds, listener);
    }

    @Override
    public RemoteEC2Instance newEC2Instance(EC2Image image, String keyName, List<String> securityGroupIds, Object userData, EC2InstanceType instanceType, String availabilityZone, int timeoutSeconds, EC2InstanceListener listener) {
        RemoteEC2InstanceImpl ec2Instance = new RemoteEC2InstanceImpl(image, keyName, securityGroupIds, userData, instanceType, availabilityZone, 10, 10, timeoutSeconds, listener, this.jec2, this.scheduledExecutorService, null);
        ec2Instance.start();
        return ec2Instance;
    }

    @Override
    public Map<String, EC2SecurityGroup> getEC2SecurityGroups() throws AWSException {
        List groupDescriptions;
        try {
            groupDescriptions = this.jec2.describeSecurityGroups(Collections.emptyList());
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to query EC2 for group descriptions.", exception);
        }
        HashMap<String, EC2SecurityGroup> ec2SecurityGroups = new HashMap<String, EC2SecurityGroup>(groupDescriptions.size());
        for (GroupDescription groupDescription : groupDescriptions) {
            ec2SecurityGroups.put(groupDescription.getName(), new EC2SecurityGroupImpl(this.jec2, groupDescription));
        }
        return ec2SecurityGroups;
    }

    @Override
    public EC2SecurityGroup newEC2SecurityGroup(String securityGroupId, String description) throws AWSException {
        try {
            this.jec2.createSecurityGroup(securityGroupId, description);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to create EC2 security group.", exception);
        }
        return new EC2SecurityGroupImpl(this.jec2, new GroupDescription(securityGroupId, description, null));
    }

    @Override
    public Map<String, EC2KeyPairDescription> getEC2KeyPairDescriptions() throws AWSException {
        List keyPairInfos;
        try {
            keyPairInfos = this.jec2.describeKeyPairs(Collections.emptyList());
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to query EC2 for key pair descriptions.", exception);
        }
        HashMap<String, EC2KeyPairDescription> ec2KeyPairDescriptions = new HashMap<String, EC2KeyPairDescription>(keyPairInfos.size());
        for (KeyPairInfo keyPairInfo : keyPairInfos) {
            ec2KeyPairDescriptions.put(keyPairInfo.getKeyName(), new EC2KeyPairDescriptionImpl(keyPairInfo));
        }
        return ec2KeyPairDescriptions;
    }

    @Override
    public EC2PrivateKey newEC2KeyPair(String name) throws AWSException {
        KeyPairInfo keyPairInfo;
        try {
            keyPairInfo = this.jec2.createKeyPair(name);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to create EC2 key pair.", exception);
        }
        return new EC2PrivateKeyImpl(keyPairInfo);
    }

    @Override
    public Map<String, EC2AvailabilityZone> getAvailabilityZones() throws AWSException {
        return this.getAvailabilityZones(null);
    }

    @Override
    public Map<String, EC2AvailabilityZone> getAvailabilityZones(List<String> zones) throws AWSException {
        List availabilityZones;
        try {
            availabilityZones = this.jec2.describeAvailabilityZones(zones);
        }
        catch (EC2Exception exception) {
            throw new AWSException("Failed to query EC2 for availability zones descriptions.", exception);
        }
        HashMap<String, EC2AvailabilityZone> ec2AvailabilityZones = new HashMap<String, EC2AvailabilityZone>(availabilityZones.size());
        for (AvailabilityZone availabilityZone : availabilityZones) {
            ec2AvailabilityZones.put(availabilityZone.getName(), new EC2AvailabilityZoneImpl(availabilityZone));
        }
        return ec2AvailabilityZones;
    }
}

