package com.atlassian.aws.utils;

import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;

class URLFetcherImpl implements URLFetcher
{

    @NotNull
    @Override
    public String fetchString(final String url)
            throws IOException
    {
        return new String(fetchData(url), StandardCharsets.UTF_8);
    }

    @NotNull
    @Override
    public byte[] fetchData(final String url) throws IOException
    {
        try(final InputStream inputStream = new URL(url).openStream())
        {
            final byte[] buffer = new byte[16 * 1024];
            int read;

            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((read = inputStream.read(buffer)) >= 0)
            {
                baos.write(buffer, 0, read);
            }
            return baos.toByteArray();
        }
    }
}
