package com.atlassian.aws.s3;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class S3UtilsThin
{
    /**
     * Caclulates a hash value comatible with S3's ETag.
     */
    @NotNull
    public static String calculateEtag(@NotNull final File file, final long chunkingThreshold, final long chunkSize) throws IOException
    {
        final MessageDigest md5digest;
        try
        {
            md5digest = MessageDigest.getInstance("MD5");
        }
        catch (final NoSuchAlgorithmException e)
        {
            throw new IllegalStateException(e);
        }

        int digests=0;
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        try(final DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(file), md5digest))
        {
            final boolean shouldUseMultipartUpload = file.length() > chunkingThreshold;
            final long toRead = shouldUseMultipartUpload ? chunkSize : Long.MAX_VALUE;
            while (skip(digestInputStream, toRead)==toRead)
            {
                baos.write(md5digest.digest());
                md5digest.reset();
                ++digests;
            }
            baos.write(md5digest.digest());
            ++digests;
        }

        if (digests==1)
        {
            return Hex.encodeHexString(baos.toByteArray());
        }
        else
        {
            return DigestUtils.md5Hex(baos.toByteArray()) + "-" + digests;
        }
    }

    private static long skip(final InputStream input, final long toSkip) throws IOException
    {
        final int bufSize = 4096;
        final byte[] buf = new byte[bufSize];
        long remainingToRead=toSkip;
        while (remainingToRead > 0) {
            final int numRead = input.read(buf, 0, (int) Math.min(remainingToRead, bufSize));
            if (numRead == -1)
            {
                break;
            }
            remainingToRead -= numRead;
        }
        return toSkip - remainingToRead;
    }
}
