/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.atlassian.aws.HttpClientConfigurationUtilsDoNotUse;
import com.atlassian.aws.s3.BambooAmazonS3Client;
import com.atlassian.aws.s3.S3Support;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.Nullable;

public class AmazonClients {
    private static final int DEFAULT_TRANSMISSION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final Logger log = Logger.getLogger(AmazonClients.class);
    private static final AtomicBoolean logRegionOnce = new AtomicBoolean();
    private static AtomicReference<Region> currentRegion = null;

    private AmazonClients() {
    }

    public static AmazonS3ClientBuilder newS3Client(AWSCredentials awsCredentials) {
        ClientConfiguration clientConfiguration = HttpClientConfigurationUtilsDoNotUse.newClientConfiguration(DEFAULT_TRANSMISSION_TIMEOUT_MS, 5);
        AmazonS3ClientBuilder s3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withDualstackEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(awsCredentials))).withClientConfiguration(clientConfiguration);
        Region currentRegion = AmazonClients.getCurrentRegion();
        if (currentRegion != null) {
            Level level = logRegionOnce.compareAndSet(false, true) ? Level.INFO : Level.DEBUG;
            log.log((Priority)level, (Object)("Detected current region as " + currentRegion + ", using it for S3 access"));
            s3ClientBuilder.withRegion(AmazonClients.toRegions(currentRegion));
        }
        return s3ClientBuilder;
    }

    @Deprecated
    public static BambooAmazonS3Client newAmazonS3Client(AWSCredentials awsCredentials) {
        ClientConfiguration clientConfiguration = HttpClientConfigurationUtilsDoNotUse.newClientConfiguration(DEFAULT_TRANSMISSION_TIMEOUT_MS, 5);
        BambooAmazonS3Client amazonS3Client = new BambooAmazonS3Client(awsCredentials, clientConfiguration);
        Region currentRegion = AmazonClients.getCurrentRegion();
        if (currentRegion != null) {
            Level level = logRegionOnce.compareAndSet(false, true) ? Level.INFO : Level.DEBUG;
            log.log((Priority)level, (Object)("Detected current region " + currentRegion + ", using it for S3 access"));
            amazonS3Client.setRegion(currentRegion);
        }
        return amazonS3Client;
    }

    @Nullable
    private static synchronized Region getCurrentRegion() {
        if (currentRegion == null) {
            currentRegion = new AtomicReference<Region>(Regions.getCurrentRegion());
        }
        return currentRegion.get();
    }

    public static AmazonS3ClientBuilder setBestEndpointForBucket(AmazonS3ClientBuilder s3ClientBuilder, String bucket) {
        log.info((Object)("Detecting bucket location for [" + bucket + "] via " + s3ClientBuilder.getRegion() + " endpoint"));
        String bucketLocation = AmazonClients.getBucketLocation((AmazonS3)s3ClientBuilder.build(), bucket);
        if (bucketLocation == null) {
            return s3ClientBuilder;
        }
        try {
            log.debug((Object)("Bucket location: " + bucketLocation));
            Region regionFromLocation = com.amazonaws.services.s3.model.Region.fromValue((String)bucketLocation).toAWSRegion();
            String oldRegion = s3ClientBuilder.getRegion();
            s3ClientBuilder.withRegion(Regions.fromName((String)regionFromLocation.getName()));
            if (AmazonClients.getBucketLocation((AmazonS3)s3ClientBuilder.build(), bucket) != null) {
                log.info((Object)("S3 endpoint for " + bucket + " set to endpoint of region " + regionFromLocation));
            } else {
                s3ClientBuilder.withRegion(oldRegion);
                log.info((Object)("S3 endpoint for " + bucket + " left at endpoint of region " + s3ClientBuilder.getRegion()));
            }
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Unable to get bucket location, using default.", (Throwable)e);
        }
        return s3ClientBuilder;
    }

    public static void setBestEndpointForBucket(AmazonS3 s3Client, String bucket) {
        log.info((Object)("Detecting bucket location for [" + bucket + "] via " + s3Client.getRegion().toAWSRegion()));
        String bucketLocation = AmazonClients.getBucketLocation(s3Client, bucket);
        if (bucketLocation == null) {
            return;
        }
        try {
            com.amazonaws.services.s3.model.Region region = com.amazonaws.services.s3.model.Region.fromValue((String)bucketLocation);
            Region awsRegion = region.toAWSRegion();
            com.amazonaws.services.s3.model.Region oldregion = s3Client.getRegion();
            s3Client.setRegion(awsRegion);
            if (AmazonClients.getBucketLocation(s3Client, bucket) != null) {
                log.info((Object)("S3 endpoint for " + bucket + " set to: " + S3Support.getEndpoint(awsRegion)));
            } else {
                log.info((Object)("S3 endpoint for " + bucket + " left at: " + S3Support.getEndpoint(awsRegion)));
                s3Client.setRegion(oldregion.toAWSRegion());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Unable to get bucket location, using default.", (Throwable)e);
        }
    }

    @Nullable
    private static String getBucketLocation(AmazonS3 s3Client, String bucketName) {
        try {
            return s3Client.getBucketLocation(bucketName);
        }
        catch (AmazonClientException e) {
            log.warn((Object)("Unable to get bucket location for [" + bucketName + "], using default. Error: " + (Object)((Object)e)));
            log.debug((Object)"", (Throwable)e);
            return null;
        }
    }

    private static Regions toRegions(Region region) {
        return Regions.fromName((String)region.getName());
    }
}

