package com.atlassian.aws;

import com.amazonaws.DnsResolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

class SortingDnsResolver implements DnsResolver {
    private final DnsResolver dnsResolver;

    SortingDnsResolver(final DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    @Override
    public InetAddress[] resolve(final String host) throws UnknownHostException {
        final InetAddress[] addresses = dnsResolver.resolve(host);
        sort(addresses);
        return addresses;
    }

    private void sort(final InetAddress[] resolve) {
        Arrays.sort(resolve, SpeedComparator.INSTANCE);
    }
}
