package com.atlassian.aws;

import org.apache.log4j.Logger;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public enum SpeedComparator implements Comparator<InetAddress> {
    INSTANCE;

    private static final Logger log = Logger.getLogger(SpeedComparator.class);
    private static final int TIMEOUT_MS = 10000;
    
    private final Map<InetAddress, Long> latencies = new ConcurrentHashMap<>();
    
    private final Function<InetAddress, Long> latency = new Function<InetAddress, Long>() {
        @Override
        public Long apply(final InetAddress inetAddress) {
            try (final SocketChannel socketChannel = SocketChannel.open();
                 final Socket socket = socketChannel.socket()) {
                final long start = System.nanoTime();
                socket.connect(new InetSocketAddress(inetAddress, 443), TIMEOUT_MS);
                return System.nanoTime()-start;
            } catch (final IOException e) {
                log.info("Unable to reach " + inetAddress + ", prioritising other addresses");
                return Long.MAX_VALUE;
            }
        }
    };

    @Override
    public int compare(final InetAddress o1, final InetAddress o2) {
        return latencies.computeIfAbsent(o1, latency).compareTo(latencies.computeIfAbsent(o2, latency));
    }
}
