package com.atlassian.aws;

import com.amazonaws.AmazonServiceException;
import org.jetbrains.annotations.NotNull;

public enum AmazonServiceErrorCode
{
    ACCESS_DENIED("AccessDenied"),
    ADDRESS_LIMIT_EXCEEDED("AddressLimitExceeded"),
    INSUFFICIENT_INSTANCE_CAPACITY("InsufficientInstanceCapacity"),
    INVALID_ALLOCATION_ID_NOT_FOUND("InvalidAllocationID.NotFound"),
    INVALID_CLIENT_TOKEN_ID("InvalidClientTokenId"),
    INVALID_INSTANCE_ID_NOT_FOUND("InvalidInstanceID.NotFound"),
    INVALID_KEYPAIR_NOT_FOUND("InvalidKeyPair.NotFound"),
    INVALID_SPOT_FLEET_REQUEST_ID_NOT_FOUND("InvalidSpotFleetRequestId.NotFound"),
    INVALID_SPOT_INSTANCE_REQUEST_ID_NOT_FOUND("InvalidSpotInstanceRequestID.NotFound"),
    INVALID_SUBNET_ID_NOT_FOUND("InvalidSubnetID.NotFound"),
    INVALID_VOLUME_NOT_FOUND("InvalidVolume.NotFound"),
    INVALID_VPC_ID_NOT_FOUND("InvalidVpcID.NotFound"),
    MAX_SPOT_INSTANCE_COUNT_EXCEEDED("MaxSpotInstanceCountExceeded"),
    RESOURCE_ALREADY_ASSOCIATED("Resource.AlreadyAssociated"),
    UNAUTHORISED_OPERATION("UnauthorizedOperation");

    private final String errorCodeString;

    AmazonServiceErrorCode(final String errorCodeString)
    {
        this.errorCodeString = errorCodeString;
    }

    @Override
    public String toString()
    {
        return errorCodeString;
    }

    public boolean is(@NotNull final AmazonServiceException e)
    {
        return errorCodeString.equalsIgnoreCase(e.getErrorCode());
    }

    public void rethrowIfNot(final AmazonServiceException sparta)
    {
        if (!this.is(sparta))
        {
            throw sparta;
        }
    }

    public static void rethrowIfNot(final AmazonServiceException e, AmazonServiceErrorCode... errorCodes)
    {
        for (AmazonServiceErrorCode errorCode : errorCodes)
        {
            if (errorCode.is(e))
            {
                return;
            }
        }
        throw e;
    }
}
