package com.atlassian.aws.ec2;

import com.atlassian.aws.utils.JsonUtils;
import com.atlassian.aws.utils.URLFetcherUtils;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

/**
 * Ideally, this class should only have standard JDK dependencies. It can use non-standard annotations though.
 */
public final class Ec2UtilsThin
{
    private Ec2UtilsThin()
    {
    }

    static final String API_BASE_URL = "http://169.254.169.254/2016-09-02/";

    private static final String USER_DATA_URL = API_BASE_URL + "user-data";

    /**
     * @return The {@link EC2Instance} upon which the current JVM is hosted.
     * @throws java.io.IOException if necessary data could not be read.
     */
    @NotNull
    public static EC2Instance getLocalEC2Instance() throws IOException
    {
        return new LocalEC2InstanceImpl();
    }

    /**
     * <p>Retrieves a {@link java.io.Serializable serialised} object from the EC2 user data for the current host.</p>
     *
     * @return The retrieved object.
     * @throws IOException            If the user data could not be read or deserialised.
     */
    public static <T> T getUserData(final Class<T> aClass) throws IOException
    {
        boolean shouldAttemptDecompression = true;
        try
        {
            return JsonUtils.fromJson(URLFetcherUtils.fetchString(USER_DATA_URL, StandardCharsets.UTF_8, shouldAttemptDecompression), aClass);
        }
        catch (final IOException e)
        {
            shouldAttemptDecompression = false;
            return JsonUtils.fromJson(URLFetcherUtils.fetchString(USER_DATA_URL, StandardCharsets.UTF_8, shouldAttemptDecompression), aClass);
        }
    }
}
